/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import java.util.Arrays;
import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.reflect.Instantiator;

public class MapperKey<K extends FieldKey<K>> {
    private final K[] keys;
    private final Class<?>[] fieldMappers;
    private final Class<?>[] constructorFieldMappers;
    private final Class<?> instantiator;
    private final Class<?> target;
    private final Class<?> source;

    public MapperKey(K[] keys, FieldMapper<?, ?>[] fieldMappers, FieldMapper<?, ?>[] constructorFieldMappers, Instantiator<?, ?> instantiator, Class<?> target, Class<?> source) {
        this.keys = keys;
        this.source = source;
        this.fieldMappers = this.getClassArray(fieldMappers);
        this.constructorFieldMappers = this.getClassArray(constructorFieldMappers);
        this.instantiator = this.getClass(instantiator);
        this.target = target;
    }

    private Class<?>[] getClassArray(Object[] objects) {
        Class[] classes = new Class[objects != null ? objects.length : 0];
        if (objects != null) {
            int i = 0;
            for (Object o : objects) {
                classes[i] = this.getClass(o);
                ++i;
            }
        }
        return classes;
    }

    private Class<?> getClass(Object o) {
        if (o != null) {
            return o.getClass();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapperKey mapperKey = (MapperKey)o;
        if (!Arrays.equals(this.keys, mapperKey.keys)) {
            return false;
        }
        if (!Arrays.equals(this.fieldMappers, mapperKey.fieldMappers)) {
            return false;
        }
        if (!Arrays.equals(this.constructorFieldMappers, mapperKey.constructorFieldMappers)) {
            return false;
        }
        if (!this.instantiator.equals(mapperKey.instantiator)) {
            return false;
        }
        if (!this.target.equals(mapperKey.target)) {
            return false;
        }
        return this.source.equals(mapperKey.source);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.keys);
        result = 31 * result + Arrays.hashCode(this.fieldMappers);
        result = 31 * result + Arrays.hashCode(this.constructorFieldMappers);
        result = 31 * result + this.instantiator.hashCode();
        result = 31 * result + this.target.hashCode();
        result = 31 * result + this.source.hashCode();
        return result;
    }
}

