/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.impl;

import java.util.HashMap;
import java.util.Map;
import org.sfm.reflect.Getter;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.TypeHelper;

public final class ArgumentBuilder<S> {
    private static final Getter NULL_GETTER = new Getter(){

        public Object get(Object target) throws Exception {
            return null;
        }
    };
    private static final Map<Class<?>, Getter> DEFAULT_GETTERS = new HashMap();
    private final Getter<? super S, ?>[] getters;

    public ArgumentBuilder(InstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) {
        Parameter[] parameters = instantiatorDefinition.getParameters();
        this.getters = new Getter[parameters.length];
        for (int i = 0; i < this.getters.length; ++i) {
            Parameter param = parameters[i];
            Getter getter = injections.get(param);
            if (getter == null) {
                getter = TypeHelper.isPrimitive(param.getType()) ? DEFAULT_GETTERS.get(param.getType()) : NULL_GETTER;
            }
            this.getters[i] = getter;
        }
    }

    public Object[] build(S source) throws Exception {
        Object[] args = new Object[this.getters.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.getters[i].get(source);
        }
        return args;
    }

    static {
        DEFAULT_GETTERS.put(Boolean.TYPE, new Getter(){

            public Object get(Object target) throws Exception {
                return Boolean.TRUE;
            }
        });
        DEFAULT_GETTERS.put(Byte.TYPE, new Getter(){

            public Object get(Object target) throws Exception {
                return (byte)0;
            }
        });
        DEFAULT_GETTERS.put(Character.TYPE, new Getter(){

            public Object get(Object target) throws Exception {
                return Character.valueOf('\u0000');
            }
        });
        DEFAULT_GETTERS.put(Short.TYPE, new Getter(){

            public Object get(Object target) throws Exception {
                return (short)0;
            }
        });
        DEFAULT_GETTERS.put(Integer.TYPE, new Getter(){

            public Object get(Object target) throws Exception {
                return 0;
            }
        });
        DEFAULT_GETTERS.put(Long.TYPE, new Getter(){

            public Object get(Object target) throws Exception {
                return 0L;
            }
        });
        DEFAULT_GETTERS.put(Float.TYPE, new Getter(){

            public Object get(Object target) throws Exception {
                return Float.valueOf(0.0f);
            }
        });
        DEFAULT_GETTERS.put(Double.TYPE, new Getter(){

            public Object get(Object target) throws Exception {
                return 0.0;
            }
        });
    }
}

