/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.tuples.Tuple2;
import org.sfm.utils.ErrorHelper;

public final class BuilderInstantiator<S, T>
implements Instantiator<S, T> {
    private final Instantiator<Void, ?> builderInstantiator;
    private final Tuple2<Method, Getter<? super S, ?>>[] chainedArguments;
    private final Tuple2<Method, Getter<? super S, ?>>[] unchainedArguments;
    private final Method buildMethod;

    public BuilderInstantiator(Instantiator<Void, ?> builderInstantiator, Tuple2<Method, Getter<? super S, ?>>[] chainedArguments, Tuple2<Method, Getter<? super S, ?>>[] unchainedArguments, Method buildMethod) {
        this.builderInstantiator = builderInstantiator;
        this.chainedArguments = chainedArguments;
        this.unchainedArguments = unchainedArguments;
        this.buildMethod = buildMethod;
    }

    @Override
    public T newInstance(S s) throws Exception {
        try {
            Object builder = this.builderInstantiator.newInstance(null);
            for (Tuple2<Method, Getter<S, ?>> tuple2 : this.chainedArguments) {
                builder = tuple2.first().invoke(builder, tuple2.second().get(s));
            }
            for (Tuple2<Method, Getter<S, ?>> tuple2 : this.unchainedArguments) {
                tuple2.first().invoke(builder, tuple2.second().get(s));
            }
            return (T)this.buildMethod.invoke(builder, new Object[0]);
        }
        catch (InvocationTargetException e) {
            return ErrorHelper.rethrow(e.getCause());
        }
    }
}

