/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.sfm.reflect.ExecutableInstantiatorDefinition;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.impl.ArgumentBuilder;
import org.sfm.utils.ErrorHelper;

public final class InjectConstructorInstantiator<S, T>
implements Instantiator<S, T> {
    private final Constructor<? extends T> constructor;
    private final ArgumentBuilder<S> argBuilder;
    private final InstantiatorDefinition instantiatorDefinition;

    public InjectConstructorInstantiator(ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) {
        this.argBuilder = new ArgumentBuilder<S>(instantiatorDefinition, injections);
        this.constructor = (Constructor)instantiatorDefinition.getExecutable();
        this.instantiatorDefinition = instantiatorDefinition;
    }

    @Override
    public T newInstance(S s) throws Exception {
        try {
            return this.constructor.newInstance(this.argBuilder.build(s));
        }
        catch (InvocationTargetException e) {
            return ErrorHelper.rethrow(e.getCause());
        }
    }

    public String toString() {
        return "InjectConstructorInstantiator{instantiatorDefinition=" + this.instantiatorDefinition + '}';
    }
}

