/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.sfm.reflect.ExecutableInstantiatorDefinition;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.impl.ArgumentBuilder;
import org.sfm.utils.ErrorHelper;

public final class InjectStaticMethodInstantiator<S, T>
implements Instantiator<S, T> {
    private final Method method;
    private final Class<?> declaringClass;
    private final ArgumentBuilder<S> argBuilder;
    private final InstantiatorDefinition instantiatorDefinition;

    public InjectStaticMethodInstantiator(ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) {
        this.argBuilder = new ArgumentBuilder<S>(instantiatorDefinition, injections);
        this.method = (Method)instantiatorDefinition.getExecutable();
        this.declaringClass = this.method.getDeclaringClass();
        this.instantiatorDefinition = instantiatorDefinition;
    }

    @Override
    public T newInstance(S s) throws Exception {
        try {
            return (T)this.method.invoke(this.declaringClass, this.argBuilder.build(s));
        }
        catch (InvocationTargetException e) {
            return ErrorHelper.rethrow(e.getCause());
        }
    }

    public String toString() {
        return "InjectStaticMethodInstantiator{instantiatorDefinition=" + this.instantiatorDefinition + '}';
    }
}

