/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sfm.reflect.EnumHelper;
import org.sfm.reflect.Getter;
import org.sfm.reflect.GetterHelper;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.InstantiatorFactory;
import org.sfm.reflect.ObjectGetterFactory;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionInstantiatorDefinitionFactory;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.impl.ConstantGetter;
import org.sfm.reflect.meta.ClassVisitor;
import org.sfm.reflect.meta.FieldAndMethodCallBack;

public class ParamNameDeductor<T> {
    private final Class<T> target;
    private List<Accessor<T>> accessors;
    private final InstantiatorFactory instantiatorFactory = new InstantiatorFactory(null);
    private static final Map<Class<?>, Object> primitivesMarkValue = new HashMap();
    private static final Map<Class<?>, Object> primitivesNeutralValue;

    public ParamNameDeductor(Class<T> target) {
        this.target = target;
    }

    public String findParamName(InstantiatorDefinition instantiatorDefinition, Parameter param) {
        if (this.accessors == null) {
            this.accessors = this.listAccessors();
        }
        try {
            Object value;
            Map<Parameter, Getter<Object, ?>> parameters = this.parametersWithExpectedValue(instantiatorDefinition, param, true);
            Instantiator instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, parameters, false);
            try {
                value = instantiator.newInstance(null);
            }
            catch (NullPointerException e) {
                parameters = this.parametersWithExpectedValue(instantiatorDefinition, param, false);
                instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, parameters, false);
                value = instantiator.newInstance(null);
            }
            if (value != null) {
                Object expectedPropertyValue = parameters.get(param).get(null);
                for (Accessor<T> accessor : this.accessors) {
                    try {
                        Object propertyValue = ((Accessor)accessor).getter.get(value);
                        if (!expectedPropertyValue.equals(propertyValue)) continue;
                        return ((Accessor)accessor).name;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Map<Parameter, Getter<? super Object, ?>> parametersWithExpectedValue(InstantiatorDefinition instantiatorDefinition, Parameter param, boolean allowNull) throws Exception {
        Map<Parameter, Getter<Object, ?>> parameterGetterMap = this.parameters(instantiatorDefinition, allowNull);
        parameterGetterMap.put(param, new ConstantGetter(this.markValue(param.getGenericType())));
        return parameterGetterMap;
    }

    private Map<Parameter, Getter<? super Object, ?>> parameters(InstantiatorDefinition instantiatorDefinition, boolean allowNull) throws Exception {
        HashMap parameterGetterMap = new HashMap();
        for (Parameter parameter : instantiatorDefinition.getParameters()) {
            Object value = this.neutralValue(parameter.getGenericType(), allowNull);
            parameterGetterMap.put(parameter, new ConstantGetter(value));
        }
        return parameterGetterMap;
    }

    private <V> V markValue(Type type) throws Exception {
        if (TypeHelper.isPrimitive(type)) {
            return (V)primitivesMarkValue.get(type);
        }
        if (TypeHelper.areEquals(type, String.class)) {
            return (V)"1";
        }
        if (TypeHelper.isAssignable(Enum.class, type)) {
            Enum[] values = EnumHelper.getValues(TypeHelper.toClass(type));
            return (V)(values.length > 1 ? values[1] : values[0]);
        }
        InstantiatorDefinition instantiatorDefinition = InstantiatorFactory.getSmallerConstructor(ReflectionInstantiatorDefinitionFactory.extractDefinitions(type));
        Instantiator instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, this.parameters(instantiatorDefinition, true), false);
        try {
            return (V)instantiator.newInstance(null);
        }
        catch (NullPointerException e) {
            instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, this.parameters(instantiatorDefinition, false), false);
            return (V)instantiator.newInstance(null);
        }
    }

    private <V> V neutralValue(Type type, boolean allowNull) throws Exception {
        if (TypeHelper.isPrimitive(type)) {
            return (V)primitivesNeutralValue.get(type);
        }
        if (allowNull) {
            return null;
        }
        if (TypeHelper.areEquals(type, String.class)) {
            return (V)"0";
        }
        if (TypeHelper.isAssignable(Enum.class, type)) {
            Enum[] values = EnumHelper.getValues(TypeHelper.toClass(type));
            return (V)values[0];
        }
        InstantiatorDefinition instantiatorDefinition = InstantiatorFactory.getSmallerConstructor(ReflectionInstantiatorDefinitionFactory.extractDefinitions(type));
        Instantiator instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, this.parameters(instantiatorDefinition, true), false);
        try {
            return (V)instantiator.newInstance(null);
        }
        catch (NullPointerException e) {
            instantiator = this.instantiatorFactory.getInstantiator(instantiatorDefinition, Object.class, this.parameters(instantiatorDefinition, false), false);
            return (V)instantiator.newInstance(null);
        }
    }

    private List<Accessor<T>> listAccessors() {
        final ArrayList<Accessor<T>> list = new ArrayList<Accessor<T>>();
        ClassVisitor.visit(this.target, new FieldAndMethodCallBack(){
            ObjectGetterFactory objectGetterFactory = new ObjectGetterFactory(null);

            @Override
            public void method(Method method) {
                if (GetterHelper.isGetter(method)) {
                    Getter methodGetter = this.objectGetterFactory.getMethodGetter(method);
                    list.add(new Accessor(GetterHelper.getPropertyNameFromMethodName(method.getName()), methodGetter));
                }
            }

            @Override
            public void field(Field field) {
                Getter fieldGetter = this.objectGetterFactory.getFieldGetter(field);
                list.add(new Accessor(field.getName(), fieldGetter));
            }
        });
        return list;
    }

    static {
        primitivesMarkValue.put(Byte.TYPE, (byte)1);
        primitivesMarkValue.put(Character.TYPE, Character.valueOf('\u0001'));
        primitivesMarkValue.put(Short.TYPE, (short)1);
        primitivesMarkValue.put(Integer.TYPE, 1);
        primitivesMarkValue.put(Long.TYPE, 1L);
        primitivesMarkValue.put(Float.TYPE, Float.valueOf(1.0f));
        primitivesMarkValue.put(Double.TYPE, 1.0);
        primitivesNeutralValue = new HashMap();
        primitivesNeutralValue.put(Byte.TYPE, (byte)0);
        primitivesNeutralValue.put(Character.TYPE, Character.valueOf('\u0000'));
        primitivesNeutralValue.put(Short.TYPE, (short)0);
        primitivesNeutralValue.put(Integer.TYPE, 0);
        primitivesNeutralValue.put(Long.TYPE, 0L);
        primitivesNeutralValue.put(Float.TYPE, Float.valueOf(0.0f));
        primitivesNeutralValue.put(Double.TYPE, 0.0);
    }

    private static class Accessor<T> {
        private final Getter<T, ?> getter;
        private final String name;

        private Accessor(String name, Getter<T, ?> getter) {
            this.getter = getter;
            this.name = name;
        }
    }
}

