/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.IndexedColumn;
import org.sfm.reflect.meta.IndexedElement;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.PropertyNameMatcher;
import org.sfm.reflect.meta.SubPropertyMeta;
import org.sfm.tuples.Tuple2;

public abstract class AbstractIndexPropertyFinder<T>
implements PropertyFinder<T> {
    protected final ClassMeta<T> classMeta;
    protected final List<IndexedElement<T, ?>> elements;
    private final Map<String, Integer> speculativeIndexes = new HashMap<String, Integer>();

    public AbstractIndexPropertyFinder(ClassMeta<T> classMeta) {
        this.elements = new ArrayList();
        this.classMeta = classMeta;
    }

    @Override
    public <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
        IndexedColumn indexedColumn = propertyNameMatcher.matchesIndex();
        if (indexedColumn == null) {
            indexedColumn = this.extrapolateIndex(propertyNameMatcher);
        }
        if (indexedColumn == null) {
            indexedColumn = this.speculativeMatching(propertyNameMatcher);
        }
        if (indexedColumn == null || !this.isValidIndex(indexedColumn)) {
            return null;
        }
        IndexedElement<T, ?> indexedElement = this.getIndexedElement(indexedColumn);
        if (indexedElement.getElementClassMeta().isLeaf() || indexedColumn.getSubPropertyNameMatcher() == null) {
            indexedElement.addProperty(".");
            return indexedElement.getPropertyMeta();
        }
        PropertyFinder<?> propertyFinder = indexedElement.getPropertyFinder();
        if (propertyFinder == null) {
            return null;
        }
        PropertyMeta subProp = propertyFinder.findProperty(indexedColumn.getSubPropertyNameMatcher());
        if (subProp == null) {
            return null;
        }
        indexedElement.addProperty(subProp);
        return new SubPropertyMeta(this.classMeta.getReflectionService(), indexedElement.getPropertyMeta(), subProp);
    }

    protected abstract boolean isValidIndex(IndexedColumn var1);

    protected abstract <E> IndexedElement<T, ?> getIndexedElement(IndexedColumn var1);

    private IndexedColumn speculativeMatching(PropertyNameMatcher propertyNameMatcher) {
        Tuple2<String, PropertyNameMatcher> speculativeMatch = propertyNameMatcher.speculativeMatch();
        IndexedColumn indexedColumn = null;
        if (speculativeMatch != null) {
            Integer index = this.speculativeIndexes.get(speculativeMatch.first());
            if (index == null) {
                indexedColumn = this.extrapolateIndex(speculativeMatch.getElement1());
                if (indexedColumn != null) {
                    this.speculativeIndexes.put(speculativeMatch.first(), indexedColumn.getIndexValue());
                }
            } else {
                indexedColumn = new IndexedColumn(index, speculativeMatch.getElement1());
            }
        }
        return indexedColumn;
    }

    protected abstract IndexedColumn extrapolateIndex(PropertyNameMatcher var1);

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.classMeta.getInstantiatorDefinitions();
    }
}

