/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.sfm.reflect.meta.AliasProvider;
import org.sfm.reflect.meta.Table;

public class ArrayAliasProvider
implements AliasProvider {
    private final AliasProvider[] providers;

    public ArrayAliasProvider(AliasProvider ... providers) {
        this.providers = providers;
    }

    @Override
    public String getAliasForMethod(Method method) {
        for (AliasProvider ap : this.providers) {
            String alias = ap.getAliasForMethod(method);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public String getAliasForField(Field field) {
        for (AliasProvider ap : this.providers) {
            String alias = ap.getAliasForField(field);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public Table getTable(Class<?> target) {
        for (AliasProvider ap : this.providers) {
            Table table = ap.getTable(target);
            if (Table.isNull(table)) continue;
            return table;
        }
        return null;
    }
}

