/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.util.ArrayList;
import java.util.List;
import org.sfm.reflect.meta.AbstractIndexPropertyFinder;
import org.sfm.reflect.meta.ArrayClassMeta;
import org.sfm.reflect.meta.ArrayElementPropertyMeta;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.IndexedColumn;
import org.sfm.reflect.meta.IndexedElement;
import org.sfm.reflect.meta.ListElementPropertyMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.PropertyNameMatcher;
import org.sfm.utils.BooleanSupplier;

public class ArrayPropertyFinder<T, E>
extends AbstractIndexPropertyFinder<T> {
    private final List<IndexedElement<T, E>> elements = new ArrayList<IndexedElement<T, E>>();

    public ArrayPropertyFinder(ArrayClassMeta<T, E> arrayClassMeta) {
        super(arrayClassMeta);
    }

    @Override
    protected IndexedElement<T, E> getIndexedElement(IndexedColumn indexedColumn) {
        while (this.elements.size() <= indexedColumn.getIndexValue()) {
            this.elements.add(new IndexedElement<T, E>(this.newElementPropertyMeta(this.elements.size(), "element" + this.elements.size()), ((ArrayClassMeta)this.classMeta).getElementClassMeta()));
        }
        return this.elements.get(indexedColumn.getIndexValue());
    }

    private PropertyMeta<T, E> newElementPropertyMeta(int index, String name) {
        ArrayClassMeta arrayClassMeta = (ArrayClassMeta)this.classMeta;
        if (arrayClassMeta.isArray()) {
            return new ArrayElementPropertyMeta(name, arrayClassMeta.getReflectionService(), index, arrayClassMeta);
        }
        return new ListElementPropertyMeta(name, arrayClassMeta.getReflectionService(), index, arrayClassMeta, new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return ArrayPropertyFinder.this.elements.size() == 1;
            }
        });
    }

    @Override
    protected IndexedColumn extrapolateIndex(PropertyNameMatcher propertyNameMatcher) {
        ClassMeta elementClassMeta = ((ArrayClassMeta)this.classMeta).getElementClassMeta();
        PropertyMeta property = elementClassMeta.newPropertyFinder().findProperty(propertyNameMatcher);
        if (property != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                IndexedElement<T, E> element = this.elements.get(i);
                if (element.hasProperty(property)) continue;
                return new IndexedColumn(i, propertyNameMatcher);
            }
            return new IndexedColumn(this.elements.size(), propertyNameMatcher);
        }
        return null;
    }

    @Override
    protected boolean isValidIndex(IndexedColumn indexedColumn) {
        return indexedColumn.getIndexValue() >= 0;
    }
}

