/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Type;
import org.sfm.reflect.Getter;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.ScoredGetter;
import org.sfm.reflect.Setter;
import org.sfm.reflect.impl.NullSetter;
import org.sfm.reflect.meta.PropertyMeta;

public class ConstructorPropertyMeta<T, P>
extends PropertyMeta<T, P> {
    private final Class<T> owner;
    private final Setter<T, P> setter = NullSetter.setter();
    private final ScoredGetter<T, P> scoredGetter;
    private final Parameter parameter;
    private final InstantiatorDefinition instantiatorDefinition;

    public ConstructorPropertyMeta(String name, ReflectionService reflectService, Parameter parameter, Class<T> owner, InstantiatorDefinition instantiatorDefinition) {
        this(name, reflectService, parameter, owner, ScoredGetter.nullGetter(), instantiatorDefinition);
    }

    public ConstructorPropertyMeta(String name, ReflectionService reflectService, Parameter parameter, Class<T> owner, ScoredGetter<T, P> scoredGetter, InstantiatorDefinition instantiatorDefinition) {
        super(name, reflectService);
        this.parameter = parameter;
        this.owner = owner;
        this.scoredGetter = scoredGetter;
        this.instantiatorDefinition = instantiatorDefinition;
    }

    public int getConstructorParameterSize() {
        return this.instantiatorDefinition.getParameters().length;
    }

    @Override
    public Setter<T, P> getSetter() {
        return this.setter;
    }

    @Override
    public Getter<T, P> getGetter() {
        return this.scoredGetter.getGetter();
    }

    public ConstructorPropertyMeta<T, P> getter(ScoredGetter<T, P> getter) {
        if (getter.isBetterThan(this.scoredGetter)) {
            return new ConstructorPropertyMeta<T, P>(this.getName(), this.reflectService, this.parameter, this.owner, getter, this.instantiatorDefinition);
        }
        return this;
    }

    @Override
    public Type getPropertyType() {
        return this.parameter.getGenericType();
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public boolean isConstructorProperty() {
        return true;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    public String toString() {
        return "ConstructorPropertyMeta{owner=" + this.owner + ", constructorParameter=" + this.parameter + '}';
    }
}

