/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.sfm.map.MapperBuildingException;
import org.sfm.reflect.Getter;
import org.sfm.reflect.IdentityGetter;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.impl.NullSetter;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.PropertyNameMatcher;

public final class DirectClassMeta<T>
implements ClassMeta<T> {
    public static final String[] HEADERS = new String[]{""};
    public static final IdentityGetter IDENTITY_GETTER = new IdentityGetter();
    private final ReflectionService reflectService;
    private final Type target;

    public DirectClassMeta(Type target, ReflectionService reflectService) throws MapperBuildingException {
        this.target = target;
        this.reflectService = reflectService;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return new DirectPropertyFinder();
    }

    @Override
    public Type getType() {
        return this.target;
    }

    @Override
    public String[] generateHeaders() {
        return HEADERS;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return Collections.emptyList();
    }

    public String toString() {
        return "DirectClassMeta{target=" + this.target + '}';
    }

    public class DirectPropertyMeta<E>
    extends PropertyMeta<T, E> {
        private final Type type;

        public DirectPropertyMeta(String name, ReflectionService reflectService, Type type) {
            super(name, reflectService);
            this.type = type;
        }

        @Override
        public Setter<T, E> getSetter() {
            return NullSetter.setter();
        }

        @Override
        public Getter<T, E> getGetter() {
            return IDENTITY_GETTER;
        }

        @Override
        public Type getPropertyType() {
            return this.type;
        }

        @Override
        public String getPath() {
            return ".";
        }

        public String toString() {
            return "DirectPropertyMeta{type=" + this.type + ",name=" + this.getName() + '}';
        }

        @Override
        public boolean isDirect() {
            return true;
        }
    }

    public class DirectPropertyFinder
    implements PropertyFinder<T> {
        @Override
        public <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
            return new DirectPropertyMeta("direct", DirectClassMeta.this.reflectService, DirectClassMeta.this.target);
        }

        @Override
        public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
            return null;
        }
    }
}

