/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sfm.reflect.ExecutableInstantiatorDefinition;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.MapPropertyFinder;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.utils.conv.Converter;
import org.sfm.utils.conv.ConverterFactory;

public class MapClassMeta<M extends Map<K, V>, K, V>
implements ClassMeta<M> {
    private final ReflectionService reflectionService;
    private final Converter<CharSequence, K> keyConverter;
    private final ClassMeta<V> valueClassMeta;
    private final Type type;
    private final Constructor<?> constructor;

    public MapClassMeta(Type type, Type keyType, Type valueType, ReflectionService reflectionService) {
        this.type = type;
        this.keyConverter = ConverterFactory.getConverter(CharSequence.class, keyType, new Object[0]);
        if (this.keyConverter == null) {
            throw new IllegalArgumentException("Unsupported key type " + keyType);
        }
        this.reflectionService = reflectionService;
        this.valueClassMeta = reflectionService.getClassMeta(valueType);
        this.constructor = this.getConstructor(type);
    }

    private Constructor<?> getConstructor(Type type) {
        Class<?> implClass = this.findMapImpl(type);
        try {
            return implClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No empty constructor for " + implClass);
        }
    }

    private Class<?> findMapImpl(Type type) {
        Class clazz = TypeHelper.toClass(type);
        if (clazz.isInterface()) {
            if (Map.class.equals(clazz)) {
                return HashMap.class;
            }
            if (ConcurrentMap.class.equals(clazz)) {
                return ConcurrentHashMap.class;
            }
        } else if (!Modifier.isAbstract(clazz.getModifiers())) {
            return clazz;
        }
        throw new IllegalArgumentException("No known Map impl for " + type);
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<M> newPropertyFinder() {
        return new MapPropertyFinder(this, this.valueClassMeta, this.keyConverter);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String[] generateHeaders() {
        throw new UnsupportedOperationException("Cannot generate headers for map");
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return Arrays.asList(new ExecutableInstantiatorDefinition(this.constructor, new Parameter[0]));
    }
}

