/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Type;
import java.util.Map;
import org.sfm.reflect.Getter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.PropertyNameMatcher;

public class MapElementPropertyMeta<T extends Map<K, V>, K, V>
extends PropertyMeta<T, V> {
    private final ClassMeta<V> valueMetaData;
    private final K key;
    private final MapSetter<T, K, V> setter;
    private final MapGetter<T, K, V> getter;

    public MapElementPropertyMeta(PropertyNameMatcher propertyNameMatcher, ReflectionService reflectService, ClassMeta<V> valueMetaData, K key) {
        super(propertyNameMatcher.toString(), reflectService);
        this.valueMetaData = valueMetaData;
        this.key = key;
        this.setter = new MapSetter(key);
        this.getter = new MapGetter(key);
    }

    @Override
    public Setter<T, V> getSetter() {
        return this.setter;
    }

    @Override
    public Getter<T, V> getGetter() {
        return this.getter;
    }

    @Override
    public Type getPropertyType() {
        return this.valueMetaData.getType();
    }

    @Override
    public String getPath() {
        return this.key + "." + this.getName();
    }

    public K getKey() {
        return this.key;
    }

    public String toString() {
        return "MapElementPropertyMeta{key=" + this.key + '}';
    }

    private static class MapGetter<T extends Map<K, V>, K, V>
    implements Getter<T, V> {
        private final K key;

        private MapGetter(K key) {
            this.key = key;
        }

        @Override
        public V get(T target) throws Exception {
            return target.get(this.key);
        }
    }

    private static class MapSetter<T extends Map<K, V>, K, V>
    implements Setter<T, V> {
        private final K key;

        private MapSetter(K key) {
            this.key = key;
        }

        @Override
        public void set(T target, V value) throws Exception {
            target.put(this.key, value);
        }
    }
}

