/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.OptionalClassMeta;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.PropertyNameMatcher;
import org.sfm.reflect.meta.SubPropertyMeta;

public class OptionalPropertyFinder<T>
implements PropertyFinder<Optional<T>> {
    private final OptionalClassMeta<T> tupleClassMeta;
    private final PropertyFinder<T> propertyFinder;
    private int nbProp = 0;
    private final ClassMeta<T> innerMeta;

    public OptionalPropertyFinder(OptionalClassMeta<T> tupleClassMeta) {
        this.tupleClassMeta = tupleClassMeta;
        this.innerMeta = tupleClassMeta.getInnerMeta();
        this.propertyFinder = this.innerMeta != null ? this.innerMeta.newPropertyFinder() : null;
    }

    @Override
    public <E> PropertyMeta<Optional<T>, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
        if (!this.innerMeta.isLeaf()) {
            PropertyMeta property = this.propertyFinder.findProperty(propertyNameMatcher);
            if (property != null) {
                return this.getSubPropertyMeta(property);
            }
        } else if (this.nbProp == 0) {
            ++this.nbProp;
            return this.tupleClassMeta.getProperty();
        }
        return null;
    }

    private <I, E> PropertyMeta<Optional<T>, E> getSubPropertyMeta(PropertyMeta<I, ?> property) {
        return new SubPropertyMeta(this.tupleClassMeta.getReflectionService(), this.tupleClassMeta.getProperty(), property);
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return Arrays.asList(this.tupleClassMeta.getInstantiatorDefinition());
    }
}

