/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Type;
import org.sfm.reflect.Getter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.meta.ClassMeta;

public abstract class PropertyMeta<O, P> {
    private final String name;
    protected final ReflectionService reflectService;
    private volatile ClassMeta<P> classMeta;

    public PropertyMeta(String name, ReflectionService reflectService) {
        this.name = name;
        this.reflectService = reflectService;
    }

    public abstract Setter<O, P> getSetter();

    public abstract Getter<O, P> getGetter();

    public final String getName() {
        return this.name;
    }

    public abstract Type getPropertyType();

    public final ClassMeta<P> getPropertyClassMeta() {
        ClassMeta<P> meta = this.classMeta;
        if (meta == null) {
            this.classMeta = meta = this.newPropertyClassMeta();
        }
        return meta;
    }

    protected ClassMeta<P> newPropertyClassMeta() {
        return this.reflectService.getClassMeta(this.getPropertyType());
    }

    public boolean isConstructorProperty() {
        return false;
    }

    public abstract String getPath();

    public boolean isSubProperty() {
        return false;
    }

    public boolean isDirect() {
        return false;
    }
}

