/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Type;
import org.sfm.reflect.Getter;
import org.sfm.reflect.GetterOnGetter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyMeta;

public class SubPropertyMeta<O, I, P>
extends PropertyMeta<O, P> {
    private final PropertyMeta<O, I> ownerProperty;
    private final PropertyMeta<I, P> subProperty;
    private final GetterOnGetter<O, I, P> getter;

    public SubPropertyMeta(ReflectionService reflectService, PropertyMeta<O, I> property, PropertyMeta<I, P> subProperty) {
        super(property.getName(), reflectService);
        this.ownerProperty = property;
        this.subProperty = subProperty;
        this.getter = new GetterOnGetter<O, I, P>(this.ownerProperty.getGetter(), subProperty.getGetter());
    }

    @Override
    public Setter<O, P> getSetter() {
        if (this.subProperty.getSetter() != null && this.ownerProperty.getGetter() != null) {
            return new Setter<O, P>(){

                @Override
                public void set(O target, P value) throws Exception {
                    SubPropertyMeta.this.subProperty.getSetter().set(SubPropertyMeta.this.ownerProperty.getGetter().get(target), value);
                }
            };
        }
        return null;
    }

    @Override
    public Getter<O, P> getGetter() {
        return this.getter;
    }

    @Override
    protected ClassMeta<P> newPropertyClassMeta() {
        return this.subProperty.getPropertyClassMeta();
    }

    @Override
    public Type getPropertyType() {
        return this.subProperty.getPropertyType();
    }

    public PropertyMeta<O, I> getOwnerProperty() {
        return this.ownerProperty;
    }

    public PropertyMeta<I, P> getSubProperty() {
        return this.subProperty;
    }

    @Override
    public boolean isSubProperty() {
        return true;
    }

    @Override
    public String getPath() {
        return this.getOwnerProperty().getPath() + "." + this.subProperty.getPath();
    }

    public String toString() {
        return "SubPropertyMeta{ownerProperty=" + this.ownerProperty + ", subProperty=" + this.subProperty + '}';
    }
}

