/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class ParallelReader
extends Reader {
    private static final int DEFAULT_MAX_READ = 8192;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private final Reader reader;
    private final DataProducer dataProducer;
    private final char[] buffer;
    private final int bufferMask;
    private final int maxRead;
    private AtomicLong tail = new AtomicLong();
    private AtomicLong head = new AtomicLong();
    private final long capacity;
    private long tailCache;
    private long headCache;
    private final long padding;

    public ParallelReader(Reader reader, Executor executorService) {
        this(reader, executorService, 32768);
    }

    public ParallelReader(Reader reader, Executor executorService, int bufferSize) {
        this(reader, executorService, bufferSize, 8192);
    }

    public ParallelReader(Reader reader, Executor executorService, int bufferSize, int maxRead) {
        int powerOf2 = 1 << 32 - Integer.numberOfLeadingZeros(bufferSize - 1);
        this.padding = powerOf2 <= 1024 ? 0L : 64L;
        this.reader = reader;
        this.buffer = new char[powerOf2];
        this.bufferMask = this.buffer.length - 1;
        this.dataProducer = new DataProducer();
        executorService.execute(this.dataProducer);
        this.capacity = this.buffer.length;
        this.maxRead = maxRead;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        long currentHead = this.head.get();
        while (true) {
            if (currentHead < this.tailCache) {
                int l = this.read(cbuf, off, len, currentHead, this.tailCache);
                this.head.lazySet(currentHead + (long)l);
                return l;
            }
            this.tailCache = this.tail.get();
            if (currentHead < this.tailCache) continue;
            if (!this.dataProducer.run) {
                if (this.dataProducer.exception != null) {
                    throw this.dataProducer.exception;
                }
                this.tailCache = this.tail.get();
                if (currentHead >= this.tailCache) {
                    return -1;
                }
            }
            this.waitingStrategy();
        }
    }

    @Override
    public int read() throws IOException {
        long currentHead = this.head.get();
        while (true) {
            if (currentHead < this.tailCache) {
                int headIndex = (int)(currentHead & (long)this.bufferMask);
                char c = this.buffer[headIndex];
                this.head.lazySet(currentHead + 1L);
                return c;
            }
            this.tailCache = this.tail.get();
            if (currentHead < this.tailCache) continue;
            if (!this.dataProducer.run) {
                if (this.dataProducer.exception != null) {
                    throw this.dataProducer.exception;
                }
                this.tailCache = this.tail.get();
                if (currentHead >= this.tailCache) {
                    return -1;
                }
            }
            this.waitingStrategy();
        }
    }

    private void waitingStrategy() {
        Thread.yield();
    }

    private int read(char[] cbuf, int off, int len, long currentHead, long currentTail) {
        int headIndex = (int)(currentHead & (long)this.bufferMask);
        int usedLength = (int)(currentTail - currentHead);
        int block1Length = Math.min(len, Math.min(usedLength, (int)(this.capacity - (long)headIndex)));
        int block2Length = Math.min(len, usedLength) - block1Length;
        System.arraycopy(this.buffer, headIndex, cbuf, off, block1Length);
        System.arraycopy(this.buffer, 0, cbuf, off + block1Length, block2Length);
        return block1Length + block2Length;
    }

    @Override
    public void close() throws IOException {
        this.dataProducer.stop();
        this.reader.close();
    }

    private class DataProducer
    implements Runnable {
        private volatile boolean run = true;
        private volatile IOException exception;

        private DataProducer() {
        }

        @Override
        public void run() {
            long currentTail = ParallelReader.this.tail.get();
            while (this.run) {
                long wrapPoint = currentTail - (long)ParallelReader.this.buffer.length;
                if (ParallelReader.this.headCache - ParallelReader.this.padding <= wrapPoint) {
                    ParallelReader.this.headCache = ParallelReader.this.head.get();
                    if (ParallelReader.this.headCache <= wrapPoint) {
                        ParallelReader.this.waitingStrategy();
                        continue;
                    }
                }
                try {
                    int r = this.read(currentTail, ParallelReader.this.headCache);
                    if (r == -1) {
                        this.run = false;
                        continue;
                    }
                    ParallelReader.this.tail.lazySet(currentTail += (long)r);
                }
                catch (IOException e) {
                    this.exception = e;
                    this.run = false;
                }
            }
        }

        private int read(long currentTail, long currentHead) throws IOException {
            long used = currentTail - currentHead;
            long length = Math.min(ParallelReader.this.capacity - used, (long)ParallelReader.this.maxRead);
            int tailIndex = (int)(currentTail & (long)ParallelReader.this.bufferMask);
            int endBlock1 = (int)Math.min((long)tailIndex + length, ParallelReader.this.capacity);
            int block1Length = endBlock1 - tailIndex;
            return ParallelReader.this.reader.read(ParallelReader.this.buffer, tailIndex, block1Length);
        }

        public void stop() {
            this.run = false;
        }
    }
}

