/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.utils.conv;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.reflect.TypeHelper;
import org.sfm.utils.conv.Converter;
import org.sfm.utils.conv.IdentityConverter;
import org.sfm.utils.conv.StringToURLConverter;
import org.sfm.utils.conv.ToStringConverter;
import org.sfm.utils.conv.joda.JodaTimeConverterFactory;
import org.sfm.utils.conv.time.JavaTimeConverterFactory;

public class ConverterFactory {
    private static final Map<Class<? extends Number>, Converter<? extends Number, ? extends Number>> numberConverters = new HashMap<Class<? extends Number>, Converter<? extends Number, ? extends Number>>();
    private static final Map<Class<?>, Converter<CharSequence, ?>> charSequenceConverters;

    public static <P, F> Converter<F, P> getConverter(Class<F> inType, Class<P> outType, Object ... params) {
        return ConverterFactory.getConverter(inType, outType, params);
    }

    public static <P, F> Converter<F, P> getConverter(Class<F> inType, Type outType, Object ... params) {
        if (TypeHelper.areEquals(outType, inType)) {
            return new IdentityConverter();
        }
        if (outType.equals(String.class)) {
            return new ToStringConverter();
        }
        if (TypeHelper.isNumber(outType) && TypeHelper.isNumber(inType)) {
            return numberConverters.get(TypeHelper.wrap(outType));
        }
        if (TypeHelper.isClass(outType, URL.class)) {
            return new StringToURLConverter();
        }
        if (TypeHelper.isAssignable(CharSequence.class, inType)) {
            if (TypeHelper.isAssignable(Enum.class, outType)) {
                return new CharSequenceToEnumConverter(TypeHelper.toClass(outType));
            }
            return charSequenceConverters.get(TypeHelper.toClass(outType));
        }
        if (JodaTimeClasses.isJoda(inType)) {
            return JodaTimeConverterFactory.getConverterFrom(inType, outType, params);
        }
        if (TypeHelper.isAssignable(Temporal.class, inType)) {
            return JavaTimeConverterFactory.getConverterFrom(inType, outType, params);
        }
        if (TypeHelper.isAssignable(Temporal.class, outType)) {
            return JavaTimeConverterFactory.getConverterTo(inType, outType, params);
        }
        return null;
    }

    static {
        numberConverters.put(Byte.class, (Converter<? extends Number, ? extends Number>)new Converter<Number, Byte>(){

            @Override
            public Byte convert(Number in) {
                if (in == null) {
                    return null;
                }
                return in.byteValue();
            }

            public String toString() {
                return "NumberToByte";
            }
        });
        numberConverters.put(Short.class, (Converter<? extends Number, ? extends Number>)new Converter<Number, Short>(){

            @Override
            public Short convert(Number in) {
                if (in == null) {
                    return null;
                }
                return in.shortValue();
            }

            public String toString() {
                return "NumberToShort";
            }
        });
        numberConverters.put(Integer.class, (Converter<? extends Number, ? extends Number>)new Converter<Number, Integer>(){

            @Override
            public Integer convert(Number in) {
                if (in == null) {
                    return null;
                }
                return in.intValue();
            }

            public String toString() {
                return "NumberToInteger";
            }
        });
        numberConverters.put(Long.class, (Converter<? extends Number, ? extends Number>)new Converter<Number, Long>(){

            @Override
            public Long convert(Number in) {
                if (in == null) {
                    return null;
                }
                return in.longValue();
            }

            public String toString() {
                return "NumberToLong";
            }
        });
        numberConverters.put(Float.class, (Converter<? extends Number, ? extends Number>)new Converter<Number, Float>(){

            @Override
            public Float convert(Number in) {
                if (in == null) {
                    return null;
                }
                return Float.valueOf(in.floatValue());
            }

            public String toString() {
                return "NumberToFloat";
            }
        });
        numberConverters.put(Double.class, (Converter<? extends Number, ? extends Number>)new Converter<Number, Double>(){

            @Override
            public Double convert(Number in) {
                if (in == null) {
                    return null;
                }
                return in.doubleValue();
            }

            public String toString() {
                return "NumberToDouble";
            }
        });
        numberConverters.put(BigDecimal.class, (Converter<? extends Number, ? extends Number>)new Converter<Number, BigDecimal>(){

            @Override
            public BigDecimal convert(Number in) {
                if (in == null) {
                    return null;
                }
                if (in instanceof BigInteger) {
                    return new BigDecimal((BigInteger)in);
                }
                return new BigDecimal(in.doubleValue());
            }

            public String toString() {
                return "NumberToBigDecimal";
            }
        });
        numberConverters.put(BigInteger.class, (Converter<? extends Number, ? extends Number>)new Converter<Number, BigInteger>(){

            @Override
            public BigInteger convert(Number in) {
                if (in == null) {
                    return null;
                }
                if (in instanceof BigDecimal) {
                    return ((BigDecimal)in).toBigInteger();
                }
                return BigInteger.valueOf(in.longValue());
            }

            public String toString() {
                return "NumberToBigInteger";
            }
        });
        charSequenceConverters = new HashMap();
        charSequenceConverters.put(Byte.class, new Converter<CharSequence, Byte>(){

            @Override
            public Byte convert(CharSequence in) throws Exception {
                if (in == null) {
                    return null;
                }
                return Byte.valueOf(in.toString());
            }

            public String toString() {
                return "CharSequenceToByte";
            }
        });
        charSequenceConverters.put(Character.class, new Converter<CharSequence, Character>(){

            @Override
            public Character convert(CharSequence in) throws Exception {
                if (in == null) {
                    return null;
                }
                return Character.valueOf((char)Integer.parseInt(in.toString()));
            }

            public String toString() {
                return "CharSequenceToCharacter";
            }
        });
        charSequenceConverters.put(Short.class, new Converter<CharSequence, Short>(){

            @Override
            public Short convert(CharSequence in) throws Exception {
                if (in == null) {
                    return null;
                }
                return Short.valueOf(in.toString());
            }

            public String toString() {
                return "CharSequenceToShort";
            }
        });
        charSequenceConverters.put(Integer.class, new Converter<CharSequence, Integer>(){

            @Override
            public Integer convert(CharSequence in) throws Exception {
                if (in == null) {
                    return null;
                }
                return Integer.valueOf(in.toString());
            }

            public String toString() {
                return "CharSequenceToInteger";
            }
        });
        charSequenceConverters.put(Long.class, new Converter<CharSequence, Long>(){

            @Override
            public Long convert(CharSequence in) throws Exception {
                if (in == null) {
                    return null;
                }
                return Long.valueOf(in.toString());
            }

            public String toString() {
                return "CharSequenceToLong";
            }
        });
        charSequenceConverters.put(Float.class, new Converter<CharSequence, Float>(){

            @Override
            public Float convert(CharSequence in) throws Exception {
                if (in == null) {
                    return null;
                }
                return Float.valueOf(in.toString());
            }

            public String toString() {
                return "CharSequenceToFloat";
            }
        });
        charSequenceConverters.put(Double.class, new Converter<CharSequence, Double>(){

            @Override
            public Double convert(CharSequence in) throws Exception {
                if (in == null) {
                    return null;
                }
                return Double.valueOf(in.toString());
            }

            public String toString() {
                return "CharSequenceToDouble";
            }
        });
        charSequenceConverters.put(UUID.class, new Converter<CharSequence, UUID>(){

            @Override
            public UUID convert(CharSequence in) throws Exception {
                if (in == null) {
                    return null;
                }
                return UUID.fromString(in.toString());
            }

            public String toString() {
                return "CharSequenceToUUID";
            }
        });
    }

    static class CharSequenceToEnumConverter<E extends Enum<E>>
    implements Converter<CharSequence, E> {
        private final Class<E> enumClass;

        CharSequenceToEnumConverter(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public E convert(CharSequence in) throws Exception {
            return Enum.valueOf(this.enumClass, in.toString());
        }
    }
}

