/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.utils.conv.joda;

import java.lang.reflect.Type;
import java.util.Date;
import org.sfm.map.column.joda.JodaHelper;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.reflect.TypeHelper;
import org.sfm.utils.conv.Converter;
import org.sfm.utils.conv.joda.JodaDateTimeTojuDateConverter;
import org.sfm.utils.conv.joda.JodaInstantTojuDateConverter;
import org.sfm.utils.conv.joda.JodaLocalDateTimeTojuDateConverter;
import org.sfm.utils.conv.joda.JodaLocalDateTojuDateConverter;
import org.sfm.utils.conv.joda.JodaLocalTimeTojuDateConverter;

public class JodaTimeConverterFactory {
    public static <F, P> Converter<F, P> getConverterFrom(Class<F> inType, Type outType, Object ... params) {
        if (TypeHelper.areEquals(Date.class, outType)) {
            if (JodaTimeClasses.isJodaLocalDateTime(inType)) {
                return new JodaLocalDateTimeTojuDateConverter(JodaHelper.getDateTimeZoneOrDefault(params));
            }
            if (JodaTimeClasses.isJodaLocalTime(inType)) {
                return new JodaLocalTimeTojuDateConverter(JodaHelper.getDateTimeZoneOrDefault(params));
            }
            if (JodaTimeClasses.isJodaLocalDate(inType)) {
                return new JodaLocalDateTojuDateConverter();
            }
            if (JodaTimeClasses.isJodaDateTime(inType)) {
                return new JodaDateTimeTojuDateConverter();
            }
            if (JodaTimeClasses.isJodaInstant(inType)) {
                return new JodaInstantTojuDateConverter();
            }
        }
        return null;
    }
}

