/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.utils.conv.time;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Date;
import org.sfm.map.column.time.JavaTimeHelper;
import org.sfm.reflect.TypeHelper;
import org.sfm.utils.conv.Converter;
import org.sfm.utils.conv.time.DateToJavaInstantConverter;
import org.sfm.utils.conv.time.DateToJavaLocalDateConverter;
import org.sfm.utils.conv.time.DateToJavaLocalDateTimeConverter;
import org.sfm.utils.conv.time.DateToJavaLocalTimeConverter;
import org.sfm.utils.conv.time.DateToJavaOffsetDateTimeConverter;
import org.sfm.utils.conv.time.DateToJavaOffsetTimeConverter;
import org.sfm.utils.conv.time.DateToJavaYearConverter;
import org.sfm.utils.conv.time.DateToJavaYearMonthConverter;
import org.sfm.utils.conv.time.DateToJavaZonedDateTimeConverter;
import org.sfm.utils.conv.time.JavaInstantTojuDateConverter;
import org.sfm.utils.conv.time.JavaLocalDateTimeTojuDateConverter;
import org.sfm.utils.conv.time.JavaLocalDateTojuDateConverter;
import org.sfm.utils.conv.time.JavaLocalTimeTojuDateConverter;
import org.sfm.utils.conv.time.JavaOffsetDateTimeTojuDateConverter;
import org.sfm.utils.conv.time.JavaOffsetTimeTojuDateConverter;
import org.sfm.utils.conv.time.JavaYearMonthTojuDateConverter;
import org.sfm.utils.conv.time.JavaYearTojuDateConverter;
import org.sfm.utils.conv.time.JavaZonedDateTimeTojuDateConverter;

public class JavaTimeConverterFactory {
    public static <F, P> Converter<F, P> getConverterFrom(Class<F> inType, Type outType, Object[] params) {
        if (TypeHelper.areEquals(Date.class, outType)) {
            if (Instant.class.equals(inType)) {
                return new JavaInstantTojuDateConverter();
            }
            if (LocalDateTime.class.equals(inType)) {
                return new JavaLocalDateTimeTojuDateConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (LocalDate.class.equals(inType)) {
                return new JavaLocalDateTojuDateConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (LocalTime.class.equals(inType)) {
                return new JavaLocalTimeTojuDateConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (ZonedDateTime.class.equals(inType)) {
                return new JavaZonedDateTimeTojuDateConverter();
            }
            if (OffsetDateTime.class.equals(inType)) {
                return new JavaOffsetDateTimeTojuDateConverter();
            }
            if (OffsetTime.class.equals(inType)) {
                return new JavaOffsetTimeTojuDateConverter();
            }
            if (YearMonth.class.equals(inType)) {
                return new JavaYearMonthTojuDateConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (Year.class.equals(inType)) {
                return new JavaYearTojuDateConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
        }
        return null;
    }

    public static <F, P> Converter<F, P> getConverterTo(Class<F> inType, Type outType, Object[] params) {
        if (TypeHelper.isAssignable(Date.class, inType)) {
            if (Instant.class.equals((Object)outType)) {
                return new DateToJavaInstantConverter();
            }
            if (LocalDateTime.class.equals((Object)outType)) {
                return new DateToJavaLocalDateTimeConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (LocalDate.class.equals((Object)outType)) {
                return new DateToJavaLocalDateConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (LocalTime.class.equals((Object)outType)) {
                return new DateToJavaLocalTimeConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (ZonedDateTime.class.equals((Object)outType)) {
                return new DateToJavaZonedDateTimeConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (OffsetDateTime.class.equals((Object)outType)) {
                return new DateToJavaOffsetDateTimeConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (OffsetTime.class.equals((Object)outType)) {
                return new DateToJavaOffsetTimeConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (YearMonth.class.equals((Object)outType)) {
                return new DateToJavaYearMonthConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
            if (Year.class.equals((Object)outType)) {
                return new DateToJavaYearConverter(JavaTimeHelper.getZoneIdOrDefault(params));
            }
        }
        return null;
    }
}

