/*
 * Copyright © 2021 Benny Bottema (benny@bennybottema.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.simplejavamail.utils.mail.smime;

/**
 * A {@link RuntimeException} that is used to indicate S/MIME specific
 * missbehaviors or to wrap other {@link Exception Exceptions} that were thrown
 * during the processing of S/MIME specific operations.
 * 
 * @author Torsten Krause (tk at markenwerk dot net)
 * @since 1.0.0
 */
public class SmimeException extends RuntimeException {

	private static final long serialVersionUID = 5400625787171945502L;

	/**
	 * Create a new {@code SmimeException} with the given message and cause.
	 * 
	 * @param message
	 *            The message of this {@code SmimeException}.
	 * @param cause
	 *            The causing {@link Exception} wrapped by this
	 *            {@code SmimeException}.
	 */
	public SmimeException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Create a new {@code SmimeException} with the given message.
	 * 
	 * @param message
	 *            The message of this {@code SmimeException}.
	 */
	public SmimeException(String message) {
		super(message);
	}
	
}
