/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.utils.mail.smime;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;

public class SmimeKey {
    private final PrivateKey privateKey;
    private final X509Certificate[] certificateChain;
    private List<String> addresses;

    public SmimeKey(PrivateKey privateKey, X509Certificate ... certificateChain) {
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificateChain[0];
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificateChain != null ? (X509Certificate[])this.certificateChain.clone() : null;
    }

    public List<String> getAssociatedAddresses() {
        if (this.addresses == null) {
            this.extractAssociatedAddresses();
        }
        return this.addresses;
    }

    private void extractAssociatedAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            X500Principal principal;
            X509Certificate certificate = this.getCertificate();
            if (null != certificate && null != (principal = certificate.getSubjectX500Principal())) {
                String name = principal.getName();
                StringTokenizer tokenizer = new StringTokenizer(name, ",");
                while (tokenizer.hasMoreTokens()) {
                    String next = tokenizer.nextToken();
                    if (!next.startsWith("E=")) continue;
                    addresses.add(next.substring(2));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addresses = Collections.unmodifiableList(addresses);
    }
}

