/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.ant;

import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Task;
import org.sonarsource.scanner.ant.SonarQubeTaskUtils;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.LogOutput;

public class SonarQubeTask
extends Task {
    private static final String PROJECT_BASEDIR_PROPERTY = "sonar.projectBaseDir";
    private static final String VERBOSE_PROPERTY = "sonar.verbose";

    public void execute() {
        this.log(Main.getAntVersion());
        this.log("SonarQube Ant Task version: " + SonarQubeTaskUtils.getTaskVersion());
        this.log("Loaded from: " + SonarQubeTaskUtils.getJarPath());
        Properties allProps = new Properties();
        allProps.put(PROJECT_BASEDIR_PROPERTY, this.getProject().getBaseDir().getAbsolutePath());
        if (SonarQubeTaskUtils.getAntLoggerLever(this.getProject()) >= 3) {
            allProps.put(VERBOSE_PROPERTY, "true");
        }
        allProps.putAll((Map<?, ?>)this.getProject().getProperties());
        this.launchAnalysis(allProps);
    }

    void launchAnalysis(Properties properties) {
        EmbeddedScanner runner = EmbeddedScanner.create(new LogOutputImplementation()).addGlobalProperties(properties).unmask("org.apache.tools.ant").unmask("org.sonar.ant").setApp("Ant", SonarQubeTaskUtils.getTaskVersion());
        runner.start();
        try {
            runner.addExtensions(this.getProject());
        }
        catch (Exception exception) {
            // empty catch block
        }
        runner.runAnalysis(properties);
        runner.stop();
    }

    private static int toAntLevel(LogOutput.Level level) {
        switch (level) {
            case TRACE: {
                return 4;
            }
            case DEBUG: {
                return 3;
            }
            case INFO: {
                return 2;
            }
            case WARN: {
                return 1;
            }
            case ERROR: {
                return 0;
            }
        }
        throw new IllegalArgumentException(level.name());
    }

    private final class LogOutputImplementation
    implements LogOutput {
        private LogOutputImplementation() {
        }

        @Override
        public void log(String formattedMessage, LogOutput.Level level) {
            SonarQubeTask.this.log(formattedMessage, SonarQubeTask.toAntLevel(level));
        }
    }
}

