/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.sonarsource.scanner.cli.Exit;
import org.sonarsource.scanner.cli.Logs;

class Cli {
    private boolean debugEnabled = false;
    private boolean displayVersionOnly = false;
    private boolean embedded = false;
    private String invokedFrom = "";
    private final Properties props = new Properties();
    private final Exit exit;
    private final Logs logger;

    public Cli(Exit exit, Logs logger) {
        this.exit = exit;
        this.logger = logger;
    }

    boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    boolean isDisplayVersionOnly() {
        return this.displayVersionOnly;
    }

    boolean isEmbedded() {
        return this.embedded;
    }

    String getInvokedFrom() {
        return this.invokedFrom;
    }

    Properties properties() {
        return this.props;
    }

    Cli parse(String[] args) {
        this.reset();
        this.props.putAll((Map<?, ?>)System.getProperties());
        if (args.length > 0) {
            int pos = 0;
            while ((pos = this.processNextArg(args, pos)) < args.length) {
            }
        }
        return this;
    }

    private int processNextArg(String[] args, int pos) {
        String arg = args[pos];
        if (pos == 0 && arg.charAt(0) != '-') {
            this.props.setProperty("sonar.task", arg);
        } else if (Arrays.asList("-h", "--help").contains(arg)) {
            this.printUsage();
            this.exit.exit(0);
        } else if (Arrays.asList("-v", "--version").contains(arg)) {
            this.displayVersionOnly = true;
        } else if (Arrays.asList("-e", "--errors").contains(arg)) {
            this.logger.info("Option -e/--errors is no longer supported and will be ignored");
        } else if (Arrays.asList("-X", "--debug").contains(arg)) {
            this.props.setProperty("sonar.verbose", "true");
            this.debugEnabled = true;
            this.logger.setDebugEnabled(true);
        } else {
            if (Arrays.asList("-D", "--define").contains(arg)) {
                return this.processProp(args, pos);
            }
            if ("--embedded".equals(arg)) {
                this.logger.info("Option --embedded is deprecated and will be removed in a future release.");
                this.embedded = true;
            } else if (arg.startsWith("--from")) {
                this.embedded = true;
                if (arg.length() > "--from=".length()) {
                    this.invokedFrom = arg.substring("--from=".length());
                }
            } else if (arg.startsWith("-D")) {
                arg = arg.substring(2);
                this.appendPropertyTo(arg, this.props);
            } else {
                this.printErrorAndExit("Unrecognized option: " + arg);
            }
        }
        return pos + 1;
    }

    private int processProp(String[] args, int pos) {
        int valuePos = pos + 1;
        if (valuePos >= args.length) {
            this.printErrorAndExit("Missing argument for option -D/--define");
        } else {
            this.appendPropertyTo(args[valuePos], this.props);
        }
        return valuePos + 1;
    }

    private void reset() {
        this.props.clear();
        this.debugEnabled = false;
        this.displayVersionOnly = false;
    }

    private void appendPropertyTo(String arg, Properties props) {
        String value;
        String key;
        int j = arg.indexOf(61);
        if (j == -1) {
            key = arg;
            value = "true";
        } else {
            key = arg.substring(0, j);
            value = arg.substring(j + 1);
        }
        Object oldValue = props.setProperty(key, value);
        if (oldValue != null) {
            this.logger.warn("Property '" + key + "' with value '" + oldValue + "' is overridden with value '" + value + "'");
        }
    }

    private void printErrorAndExit(String message) {
        this.logger.error(message);
        this.printUsage();
        this.exit.exit(1);
    }

    private void printUsage() {
        this.logger.info("");
        this.logger.info("usage: sonar-scanner [options]");
        this.logger.info("");
        this.logger.info("Options:");
        this.logger.info(" -D,--define <arg>     Define property");
        this.logger.info(" -h,--help             Display help information");
        this.logger.info(" -v,--version          Display version information");
        this.logger.info(" -X,--debug            Produce execution debug output");
    }
}

