/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import org.sonarsource.scanner.cli.Logs;
import org.sonarsource.scanner.cli.ScannerVersion;

class SystemInfo {
    private static System2 system = new System2();

    private SystemInfo() {
    }

    static void setSystem(System2 system) {
        SystemInfo.system = system;
    }

    static void print(Logs logger) {
        logger.info("SonarScanner " + ScannerVersion.version());
        logger.info(SystemInfo.java());
        logger.info(SystemInfo.os());
        String scannerOpts = system.getenv("SONAR_SCANNER_OPTS");
        if (scannerOpts != null) {
            logger.info("SONAR_SCANNER_OPTS=" + scannerOpts);
        }
    }

    static String java() {
        StringBuilder sb = new StringBuilder();
        sb.append("Java ").append(system.getProperty("java.version")).append(" ").append(system.getProperty("java.vendor"));
        String bits = system.getProperty("sun.arch.data.model");
        if ("32".equals(bits) || "64".equals(bits)) {
            sb.append(" (").append(bits).append("-bit)");
        }
        return sb.toString();
    }

    static String os() {
        StringBuilder sb = new StringBuilder();
        sb.append(system.getProperty("os.name")).append(" ").append(system.getProperty("os.version")).append(" ").append(system.getProperty("os.arch"));
        return sb.toString();
    }

    static class System2 {
        System2() {
        }

        String getProperty(String key) {
            return System.getProperty(key);
        }

        String getenv(String key) {
            return System.getenv(key);
        }
    }
}

