/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionListenerForDepMgmt;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.codehaus.plexus.logging.Logger;

public class DependencyTreeResolutionListener
implements ResolutionListener,
ResolutionListenerForDepMgmt {
    private final Logger logger;
    private final Stack<DependencyNode> parentNodes;
    private final Map<Artifact, DependencyNode> nodesByArtifact;
    private DependencyNode rootNode;
    private DependencyNode currentNode;
    private Map<String, String> managedVersions = new HashMap<String, String>();
    private Map<String, String> managedScopes = new HashMap<String, String>();

    public DependencyTreeResolutionListener(Logger logger) {
        this.logger = logger;
        this.parentNodes = new Stack();
        this.nodesByArtifact = new IdentityHashMap<Artifact, DependencyNode>();
        this.rootNode = null;
        this.currentNode = null;
    }

    public void testArtifact(Artifact artifact) {
        this.log("testArtifact: artifact=" + artifact);
    }

    public void startProcessChildren(Artifact artifact) {
        this.log("startProcessChildren: artifact=" + artifact);
        if (!this.currentNode.getArtifact().equals(artifact)) {
            throw new IllegalStateException("Artifact was expected to be " + this.currentNode.getArtifact() + " but was " + artifact);
        }
        this.parentNodes.push(this.currentNode);
    }

    public void endProcessChildren(Artifact artifact) {
        DependencyNode node = this.parentNodes.pop();
        this.log("endProcessChildren: artifact=" + artifact);
        if (node == null) {
            throw new IllegalStateException("Parent dependency node was null");
        }
        if (!node.getArtifact().equals(artifact)) {
            throw new IllegalStateException("Parent dependency node artifact was expected to be " + node.getArtifact() + " but was " + artifact);
        }
    }

    public void includeArtifact(Artifact artifact) {
        this.log("includeArtifact: artifact=" + artifact);
        DependencyNode existingNode = this.getNode(artifact);
        if (existingNode == null && this.isCurrentNodeIncluded()) {
            DependencyNode node = this.addNode(artifact);
            this.flushDependencyManagement(node);
        }
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        this.log("omitForNearer: omitted=" + omitted + " kept=" + kept);
        if (!omitted.getDependencyConflictId().equals(kept.getDependencyConflictId())) {
            throw new IllegalArgumentException("Omitted artifact dependency conflict id " + omitted.getDependencyConflictId() + " differs from kept artifact dependency conflict id " + kept.getDependencyConflictId());
        }
        if (this.isCurrentNodeIncluded()) {
            DependencyNode omittedNode = this.getNode(omitted);
            if (omittedNode != null) {
                this.removeNode(omitted);
            } else {
                this.currentNode = omittedNode = this.createNode(omitted);
            }
            omittedNode.omitForConflict(kept);
            this.flushDependencyManagement(omittedNode);
            DependencyNode keptNode = this.getNode(kept);
            if (keptNode == null) {
                this.addNode(kept);
            }
        }
    }

    public void updateScope(Artifact artifact, String scope) {
        this.log("updateScope: artifact=" + artifact + ", scope=" + scope);
        DependencyNode node = this.getNode(artifact);
        if (node == null) {
            node = this.addNode(artifact);
        }
        node.setOriginalScope(artifact.getScope());
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        this.log("manageArtifact: artifact=" + artifact + ", replacement=" + replacement);
        if (replacement.getVersion() != null) {
            this.manageArtifactVersion(artifact, replacement);
        }
        if (replacement.getScope() != null) {
            this.manageArtifactScope(artifact, replacement);
        }
    }

    public void omitForCycle(Artifact artifact) {
        this.log("omitForCycle: artifact=" + artifact);
        if (this.isCurrentNodeIncluded()) {
            DependencyNode node = this.createNode(artifact);
            node.omitForCycle();
        }
    }

    public void updateScopeCurrentPom(Artifact artifact, String scopeIgnored) {
        this.log("updateScopeCurrentPom: artifact=" + artifact + ", scopeIgnored=" + scopeIgnored);
        DependencyNode node = this.getNode(artifact);
        if (node == null) {
            node = this.addNode(artifact);
        }
        node.setFailedUpdateScope(scopeIgnored);
    }

    public void selectVersionFromRange(Artifact artifact) {
        this.log("selectVersionFromRange: artifact=" + artifact);
        DependencyNode node = this.getNode(artifact);
        if (node == null && this.isCurrentNodeIncluded()) {
            node = this.addNode(artifact);
        }
        node.setVersionSelectedFromRange(artifact.getVersionRange());
        node.setAvailableVersions(artifact.getAvailableVersions());
    }

    public void restrictRange(Artifact artifact, Artifact replacement, VersionRange versionRange) {
        this.log("restrictRange: artifact=" + artifact + ", replacement=" + replacement + ", versionRange=" + versionRange);
    }

    public void manageArtifactVersion(Artifact artifact, Artifact replacement) {
        this.log("manageArtifactVersion: artifact=" + artifact + ", replacement=" + replacement);
        if (this.isCurrentNodeIncluded() && !replacement.getVersion().equals(artifact.getVersion())) {
            this.managedVersions.put(replacement.getId(), artifact.getVersion());
        }
    }

    public void manageArtifactScope(Artifact artifact, Artifact replacement) {
        this.log("manageArtifactScope: artifact=" + artifact + ", replacement=" + replacement);
        if (this.isCurrentNodeIncluded() && !replacement.getScope().equals(artifact.getScope())) {
            this.managedScopes.put(replacement.getId(), artifact.getScope());
        }
    }

    public void manageArtifactSystemPath(Artifact artifact, Artifact replacement) {
        this.log("manageArtifactScope: artifact=" + artifact + ", replacement=" + replacement);
    }

    public Collection<DependencyNode> getNodes() {
        return Collections.unmodifiableCollection(this.nodesByArtifact.values());
    }

    public DependencyNode getRootNode() {
        return this.rootNode;
    }

    private void log(String message) {
        int depth = this.parentNodes.size();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            buffer.append("  ");
        }
        buffer.append(message);
        this.logger.debug(buffer.toString());
    }

    private DependencyNode createNode(Artifact artifact) {
        DependencyNode node = new DependencyNode(artifact);
        if (!this.parentNodes.isEmpty()) {
            DependencyNode parent = this.parentNodes.peek();
            parent.addChild(node);
        }
        return node;
    }

    DependencyNode addNode(Artifact artifact) {
        DependencyNode node = this.createNode(artifact);
        DependencyNode previousNode = this.nodesByArtifact.put(node.getArtifact(), node);
        if (previousNode != null) {
            throw new IllegalStateException("Duplicate node registered for artifact: " + node.getArtifact());
        }
        if (this.rootNode == null) {
            this.rootNode = node;
        }
        this.currentNode = node;
        return node;
    }

    private DependencyNode getNode(Artifact artifact) {
        return this.nodesByArtifact.get(artifact);
    }

    private void removeNode(Artifact artifact) {
        DependencyNode node = this.nodesByArtifact.remove(artifact);
        if (!artifact.equals(node.getArtifact())) {
            throw new IllegalStateException("Removed dependency node artifact was expected to be " + artifact + " but was " + node.getArtifact());
        }
    }

    private boolean isCurrentNodeIncluded() {
        for (DependencyNode node : this.parentNodes) {
            if (node.getState() == 0) continue;
            return false;
        }
        return true;
    }

    private void flushDependencyManagement(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        String premanagedVersion = this.managedVersions.get(artifact.getId());
        String premanagedScope = this.managedScopes.get(artifact.getId());
        if (premanagedVersion != null || premanagedScope != null) {
            if (premanagedVersion != null) {
                node.setPremanagedVersion(premanagedVersion);
            }
            if (premanagedScope != null) {
                node.setPremanagedScope(premanagedScope);
            }
            premanagedVersion = null;
            premanagedScope = null;
        }
    }
}

