/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.PropertyFieldDefinition;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.apachecommons.lang.math.NumberUtils;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Preconditions;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@ServerSide
@ComputeEngineSide
@SonarLintSide
@ExtensionPoint
public final class PropertyDefinition {
    private static final Set<String> SUPPORTED_QUALIFIERS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("TRK", "VW", "BRC", "SVW", "APP")));
    private String key;
    private String defaultValue;
    private String name;
    private PropertyType type;
    private List<String> options;
    private String description;
    private String category;
    private List<String> qualifiers;
    private boolean global;
    private boolean multiValues;
    private String propertySetKey;
    private String deprecatedKey;
    private List<PropertyFieldDefinition> fields;
    private String subCategory;
    private int index;

    private PropertyDefinition(Builder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.category = builder.category;
        this.subCategory = builder.subCategory;
        this.global = builder.global;
        this.type = builder.type;
        this.options = builder.options;
        this.multiValues = builder.multiValues;
        this.propertySetKey = builder.propertySetKey;
        this.fields = builder.fields;
        this.deprecatedKey = builder.deprecatedKey;
        this.qualifiers = builder.onQualifiers;
        this.qualifiers.addAll(builder.onlyOnQualifiers);
        this.index = builder.index;
    }

    public static Builder builder(String key) {
        return new Builder(key);
    }

    static PropertyDefinition create(Property annotation) {
        Builder builder = PropertyDefinition.builder(annotation.key()).name(annotation.name()).defaultValue(annotation.defaultValue()).description(annotation.description()).category(annotation.category()).type(annotation.type()).options(Arrays.asList(annotation.options())).multiValues(annotation.multiValues()).propertySetKey(annotation.propertySetKey()).fields(PropertyFieldDefinition.create(annotation.fields())).deprecatedKey(annotation.deprecatedKey());
        ArrayList<String> qualifiers = new ArrayList<String>();
        if (annotation.project()) {
            qualifiers.add("TRK");
        }
        if (annotation.module()) {
            qualifiers.add("BRC");
        }
        if (annotation.global()) {
            builder.onQualifiers(qualifiers);
        } else {
            builder.onlyOnQualifiers(qualifiers);
        }
        return builder.build();
    }

    public static Result validate(PropertyType type, @Nullable String value, List<String> options) {
        if (StringUtils.isBlank(value)) {
            return Result.SUCCESS;
        }
        EnumMap<PropertyType, Function<String, Result>> validations = PropertyDefinition.createValidations(options);
        return validations.getOrDefault((Object)type, aValue -> Result.SUCCESS).apply(value);
    }

    private static EnumMap<PropertyType, Function<String, Result>> createValidations(List<String> options) {
        EnumMap<PropertyType, Function<String, Result>> map = new EnumMap<PropertyType, Function<String, Result>>(PropertyType.class);
        map.put(PropertyType.BOOLEAN, PropertyDefinition.validateBoolean());
        map.put(PropertyType.INTEGER, PropertyDefinition.validateInteger());
        map.put(PropertyType.LONG, PropertyDefinition.validateInteger());
        map.put(PropertyType.FLOAT, PropertyDefinition.validateFloat());
        map.put(PropertyType.REGULAR_EXPRESSION, PropertyDefinition.validateRegexp());
        map.put(PropertyType.SINGLE_SELECT_LIST, aValue -> options.contains(aValue) ? Result.SUCCESS : Result.newError("notInOptions"));
        return map;
    }

    private static Function<String, Result> validateBoolean() {
        return value -> {
            if (!StringUtils.equalsIgnoreCase(value, "true") && !StringUtils.equalsIgnoreCase(value, "false")) {
                return Result.newError("notBoolean");
            }
            return Result.SUCCESS;
        };
    }

    private static Function<String, Result> validateInteger() {
        return value -> {
            if (!NumberUtils.isDigits(value)) {
                return Result.newError("notInteger");
            }
            return Result.SUCCESS;
        };
    }

    private static Function<String, Result> validateFloat() {
        return value -> {
            try {
                Double.parseDouble(value);
                return Result.SUCCESS;
            }
            catch (NumberFormatException e) {
                return Result.newError("notFloat");
            }
        };
    }

    private static Function<String, Result> validateRegexp() {
        return value -> {
            try {
                Pattern.compile(value);
                return Result.SUCCESS;
            }
            catch (PatternSyntaxException e) {
                return Result.newError("notRegexp");
            }
        };
    }

    public Result validate(@Nullable String value) {
        return PropertyDefinition.validate(this.type, value, this.options);
    }

    public String key() {
        return this.key;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String name() {
        return this.name;
    }

    public PropertyType type() {
        return this.type;
    }

    public List<String> options() {
        return this.options;
    }

    public String description() {
        return this.description;
    }

    public String category() {
        return this.category;
    }

    public String subCategory() {
        return this.subCategory;
    }

    public List<String> qualifiers() {
        return this.qualifiers;
    }

    public boolean global() {
        return this.global;
    }

    public boolean multiValues() {
        return this.multiValues;
    }

    @Deprecated
    public String propertySetKey() {
        return this.propertySetKey;
    }

    public List<PropertyFieldDefinition> fields() {
        return this.fields;
    }

    public String deprecatedKey() {
        return this.deprecatedKey;
    }

    public int index() {
        return this.index;
    }

    public String toString() {
        if (StringUtils.isEmpty(this.propertySetKey)) {
            return this.key;
        }
        return this.propertySetKey + '|' + this.key;
    }

    public static class Builder {
        private final String key;
        private String name = "";
        private String description = "";
        private String defaultValue = "";
        private String category = "";
        private String subCategory = "";
        private List<String> onQualifiers = new ArrayList<String>();
        private List<String> onlyOnQualifiers = new ArrayList<String>();
        private boolean global = true;
        private PropertyType type = PropertyType.STRING;
        private List<String> options = new ArrayList<String>();
        private boolean multiValues = false;
        private String propertySetKey = "";
        private List<PropertyFieldDefinition> fields = new ArrayList<PropertyFieldDefinition>();
        private String deprecatedKey = "";
        private boolean hidden = false;
        private int index = 999;

        private Builder(String key) {
            this.key = key;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder subCategory(String subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        public Builder onQualifiers(String first, String ... rest) {
            Builder.addQualifiers(this.onQualifiers, first, rest);
            this.global = true;
            return this;
        }

        public Builder onQualifiers(List<String> qualifiers) {
            Builder.addQualifiers(this.onQualifiers, qualifiers);
            this.global = true;
            return this;
        }

        public Builder onlyOnQualifiers(String first, String ... rest) {
            Builder.addQualifiers(this.onlyOnQualifiers, first, rest);
            this.global = false;
            return this;
        }

        public Builder onlyOnQualifiers(List<String> qualifiers) {
            Builder.addQualifiers(this.onlyOnQualifiers, qualifiers);
            this.global = false;
            return this;
        }

        private static void addQualifiers(List<String> target, String first, String ... rest) {
            Stream.concat(Stream.of(first), Arrays.stream(rest)).peek(Builder::validateQualifier).forEach(target::add);
        }

        private static void addQualifiers(List<String> target, List<String> qualifiers) {
            qualifiers.stream().peek(Builder::validateQualifier).forEach(target::add);
        }

        private static void validateQualifier(@Nullable String qualifier) {
            Objects.requireNonNull(qualifier, "Qualifier cannot be null");
            Preconditions.checkArgument(SUPPORTED_QUALIFIERS.contains(qualifier), "Qualifier must be one of %s", SUPPORTED_QUALIFIERS);
        }

        public Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        public Builder options(String first, String ... rest) {
            this.options.add(first);
            this.options.addAll(Arrays.asList(rest));
            return this;
        }

        public Builder options(List<String> options) {
            this.options.addAll(options);
            return this;
        }

        public Builder multiValues(boolean multiValues) {
            this.multiValues = multiValues;
            return this;
        }

        @Deprecated
        public Builder propertySetKey(String propertySetKey) {
            this.propertySetKey = propertySetKey;
            return this;
        }

        public Builder fields(PropertyFieldDefinition first, PropertyFieldDefinition ... rest) {
            this.fields.add(first);
            this.fields.addAll(Arrays.asList(rest));
            return this;
        }

        public Builder fields(List<PropertyFieldDefinition> fields) {
            this.fields.addAll(fields);
            return this;
        }

        public Builder deprecatedKey(String deprecatedKey) {
            this.deprecatedKey = deprecatedKey;
            return this;
        }

        public Builder hidden() {
            this.hidden = true;
            return this;
        }

        public Builder index(int index) {
            this.index = index;
            return this;
        }

        public PropertyDefinition build() {
            Preconditions.checkArgument(!StringUtils.isEmpty(this.key), "Key must be set");
            this.fixType(this.key, this.type);
            Preconditions.checkArgument(this.onQualifiers.isEmpty() || this.onlyOnQualifiers.isEmpty(), "Cannot define both onQualifiers and onlyOnQualifiers");
            Preconditions.checkArgument(!this.hidden || this.onQualifiers.isEmpty() && this.onlyOnQualifiers.isEmpty(), "Cannot be hidden and defining qualifiers on which to display");
            if (this.hidden) {
                this.global = false;
            }
            if (!this.fields.isEmpty()) {
                this.type = PropertyType.PROPERTY_SET;
            }
            return new PropertyDefinition(this);
        }

        private void fixType(String key, PropertyType type) {
            if (type == PropertyType.STRING) {
                if (StringUtils.endsWith(key, ".password.secured")) {
                    this.type = PropertyType.PASSWORD;
                } else if (StringUtils.endsWith(key, ".license.secured")) {
                    this.type = PropertyType.LICENSE;
                }
            }
        }
    }

    public static final class Result {
        private static final Result SUCCESS = new Result(null);
        private String errorKey;

        @Nullable
        private Result(@Nullable String errorKey) {
            this.errorKey = errorKey;
        }

        private static Result newError(String key) {
            return new Result(key);
        }

        public boolean isValid() {
            return StringUtils.isBlank(this.errorKey);
        }

        @Nullable
        public String getErrorKey() {
            return this.errorKey;
        }
    }
}

