/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.i18n;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.junit.Assert;

public class BundleSynchronizedMatcher
extends BaseMatcher<String> {
    public static final String L10N_PATH = "/org/sonar/l10n/";
    private String bundleName;
    private SortedMap<String, String> missingKeys;
    private SortedMap<String, String> additionalKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(Object arg0) {
        if (!(arg0 instanceof String)) {
            return false;
        }
        this.bundleName = (String)arg0;
        InputStream bundleInputStream = BundleSynchronizedMatcher.getBundleFileInputStream(this.bundleName);
        InputStream defaultBundleInputStream = BundleSynchronizedMatcher.getDefaultBundleFileInputStream(this.bundleName);
        try {
            this.missingKeys = BundleSynchronizedMatcher.retrieveMissingTranslations(bundleInputStream, defaultBundleInputStream);
            bundleInputStream = BundleSynchronizedMatcher.getBundleFileInputStream(this.bundleName);
            defaultBundleInputStream = BundleSynchronizedMatcher.getDefaultBundleFileInputStream(this.bundleName);
            this.additionalKeys = BundleSynchronizedMatcher.retrieveMissingTranslations(defaultBundleInputStream, bundleInputStream);
            boolean bl = this.missingKeys.isEmpty();
            return bl;
        }
        catch (IOException e) {
            Assert.fail((String)("An error occurred while reading the bundles: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bundleInputStream);
            IOUtils.closeQuietly((InputStream)defaultBundleInputStream);
        }
    }

    public void describeTo(Description description) {
        File dumpFile = new File("target/l10n/" + this.bundleName + ".report.txt");
        StringBuilder details = this.prepareDetailsMessage(dumpFile);
        description.appendText(details.toString());
        this.printReport(dumpFile, details.toString());
    }

    private StringBuilder prepareDetailsMessage(File dumpFile) {
        StringBuilder details = new StringBuilder("\n=======================\n'");
        details.append(this.bundleName);
        details.append("' is not up-to-date.");
        this.print("\n\n Missing translations are:", this.missingKeys, details);
        this.print("\n\nThe following translations do not exist in the reference bundle:", this.additionalKeys, details);
        details.append("\n\nSee report file located at: ");
        details.append(dumpFile.getAbsolutePath());
        details.append("\n=======================");
        return details;
    }

    private void print(String title, SortedMap<String, String> translations, StringBuilder to) {
        if (!translations.isEmpty()) {
            to.append(title);
            for (Map.Entry<String, String> entry : translations.entrySet()) {
                to.append("\n").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
    }

    private void printReport(File dumpFile, String details) {
        if (dumpFile.exists()) {
            dumpFile.delete();
        }
        dumpFile.getParentFile().mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), StandardCharsets.UTF_8);){
            writer.write(details);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write the report to 'target/l10n/" + this.bundleName + ".report.txt'", e);
        }
    }

    protected static SortedMap<String, String> retrieveMissingTranslations(InputStream bundle, InputStream referenceBundle) throws IOException {
        TreeMap<String, String> missingKeys = new TreeMap<String, String>();
        Properties bundleProps = BundleSynchronizedMatcher.loadProperties(bundle);
        Properties referenceProperties = BundleSynchronizedMatcher.loadProperties(referenceBundle);
        for (Map.Entry<Object, Object> entry : referenceProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (bundleProps.containsKey(key)) continue;
            missingKeys.put(key, (String)entry.getValue());
        }
        return missingKeys;
    }

    protected static Properties loadProperties(InputStream inputStream) throws IOException {
        Properties props = new Properties();
        props.load(inputStream);
        return props;
    }

    protected static InputStream getBundleFileInputStream(String bundleName) {
        InputStream bundle = BundleSynchronizedMatcher.class.getResourceAsStream(L10N_PATH + bundleName);
        Assert.assertNotNull((String)("File '" + bundleName + "' does not exist in '/org/sonar/l10n/'."), (Object)bundle);
        return bundle;
    }

    protected static InputStream getDefaultBundleFileInputStream(String bundleName) {
        String defaultBundleName = BundleSynchronizedMatcher.extractDefaultBundleName(bundleName);
        InputStream bundle = BundleSynchronizedMatcher.class.getResourceAsStream(L10N_PATH + defaultBundleName);
        Assert.assertNotNull((String)("Default bundle '" + defaultBundleName + "' could not be found: add a dependency to the corresponding plugin in your POM."), (Object)bundle);
        return bundle;
    }

    protected static String extractDefaultBundleName(String bundleName) {
        int firstUnderScoreIndex = bundleName.indexOf(95);
        Assert.assertTrue((String)("The bundle '" + bundleName + "' is a default bundle (without locale), so it can't be compared."), (firstUnderScoreIndex > 0 ? 1 : 0) != 0);
        return bundleName.substring(0, firstUnderScoreIndex) + ".properties";
    }
}

