/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.put;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorDefinition;
import org.sourcelab.kafka.connect.apiclient.request.put.PutRequest;
import org.sourcelab.kafka.connect.apiclient.util.UrlEscapingUtil;

public final class PutConnectorConfig
implements PutRequest<ConnectorDefinition> {
    private final String connectorName;
    private final Map<String, String> config;

    public PutConnectorConfig(String connectorName, Map<String, String> config) {
        Objects.requireNonNull(connectorName);
        Objects.requireNonNull(config);
        this.connectorName = connectorName;
        this.config = Collections.unmodifiableMap(new HashMap<String, String>(config));
    }

    @Override
    public String getApiEndpoint() {
        return "/connectors/" + UrlEscapingUtil.escapePath(this.connectorName) + "/config";
    }

    @Override
    public Object getRequestBody() {
        return this.config;
    }

    @Override
    public ConnectorDefinition parseResponse(String responseStr) throws IOException {
        return (ConnectorDefinition)JacksonFactory.newInstance().readValue(responseStr, ConnectorDefinition.class);
    }
}

