/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.get;

import java.io.IOException;
import java.util.Objects;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.dto.TaskStatus;
import org.sourcelab.kafka.connect.apiclient.request.get.GetRequest;
import org.sourcelab.kafka.connect.apiclient.util.UrlEscapingUtil;

public final class GetConnectorTaskStatus
implements GetRequest<TaskStatus> {
    private final String connectorName;
    private final int taskId;

    public GetConnectorTaskStatus(String connectorName, int taskId) {
        Objects.requireNonNull(connectorName);
        this.connectorName = connectorName;
        this.taskId = taskId;
    }

    @Override
    public String getApiEndpoint() {
        return "/connectors/" + UrlEscapingUtil.escapePath(this.connectorName) + "/tasks/" + this.taskId + "/status";
    }

    @Override
    public TaskStatus parseResponse(String responseStr) throws IOException {
        return (TaskStatus)JacksonFactory.newInstance().readValue(responseStr, TaskStatus.class);
    }
}

