/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.anthropic.AnthropicChatOptions;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.anthropic.metadata.AnthropicUsage;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.metadata.UsageUtils;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.Media;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AnthropicChatModel
extends AbstractToolCallSupport
implements ChatModel {
    public static final String DEFAULT_MODEL_NAME = AnthropicApi.ChatModel.CLAUDE_3_5_SONNET.getValue();
    public static final Integer DEFAULT_MAX_TOKENS = 500;
    public static final Double DEFAULT_TEMPERATURE = 0.8;
    private static final Logger logger = LoggerFactory.getLogger(AnthropicChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    public final RetryTemplate retryTemplate;
    private final AnthropicApi anthropicApi;
    private final AnthropicChatOptions defaultOptions;
    private final ObservationRegistry observationRegistry;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public AnthropicChatModel(AnthropicApi anthropicApi) {
        this(anthropicApi, AnthropicChatOptions.builder().model(DEFAULT_MODEL_NAME).maxTokens(DEFAULT_MAX_TOKENS).temperature(DEFAULT_TEMPERATURE).build());
    }

    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions) {
        this(anthropicApi, defaultOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, RetryTemplate retryTemplate) {
        this(anthropicApi, defaultOptions, retryTemplate, null);
    }

    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, RetryTemplate retryTemplate, FunctionCallbackResolver functionCallbackResolver) {
        this(anthropicApi, defaultOptions, retryTemplate, functionCallbackResolver, List.of());
    }

    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, RetryTemplate retryTemplate, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks) {
        this(anthropicApi, defaultOptions, retryTemplate, functionCallbackResolver, toolFunctionCallbacks, ObservationRegistry.NOOP);
    }

    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, RetryTemplate retryTemplate, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, ObservationRegistry observationRegistry) {
        super(functionCallbackResolver, (FunctionCallingOptions)defaultOptions, toolFunctionCallbacks);
        Assert.notNull((Object)anthropicApi, (String)"AnthropicApi must not be null");
        Assert.notNull((Object)defaultOptions, (String)"DefaultOptions must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.anthropicApi = anthropicApi;
        this.defaultOptions = defaultOptions;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public ChatResponse call(Prompt prompt) {
        return this.internalCall(prompt, null);
    }

    public ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        AnthropicApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AnthropicApi.PROVIDER_NAME).requestOptions(this.buildRequestOptions(request)).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.anthropicApi.chatCompletionEntity(request));
            AnthropicApi.ChatCompletionResponse completionResponse = (AnthropicApi.ChatCompletionResponse)completionEntity.getBody();
            AnthropicApi.Usage usage = completionResponse.usage();
            Object currentChatResponseUsage = usage != null ? AnthropicUsage.from(completionResponse.usage()) : new EmptyUsage();
            Usage accumulatedUsage = UsageUtils.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
            ChatResponse chatResponse = this.toChatResponse((AnthropicApi.ChatCompletionResponse)completionEntity.getBody(), accumulatedUsage);
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (!this.isProxyToolCalls(prompt, this.defaultOptions) && response != null && this.isToolCall(response, Set.of("tool_use"))) {
            List toolCallConversation = this.handleToolCalls(prompt, response);
            return this.internalCall(new Prompt(toolCallConversation, prompt.getOptions()), response);
        }
        return response;
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return this.internalStream(prompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            AnthropicApi.ChatCompletionRequest request = this.createRequest(prompt, true);
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AnthropicApi.PROVIDER_NAME).requestOptions(this.buildRequestOptions(request)).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux<AnthropicApi.ChatCompletionResponse> response = this.anthropicApi.chatCompletionStream(request);
            Flux chatResponseFlux = response.switchMap(chatCompletionResponse -> {
                AnthropicApi.Usage usage = chatCompletionResponse.usage();
                Object currentChatResponseUsage = usage != null ? AnthropicUsage.from(chatCompletionResponse.usage()) : new EmptyUsage();
                Usage accumulatedUsage = UsageUtils.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
                ChatResponse chatResponse = this.toChatResponse((AnthropicApi.ChatCompletionResponse)chatCompletionResponse, accumulatedUsage);
                if (!this.isProxyToolCalls(prompt, this.defaultOptions) && this.isToolCall(chatResponse, Set.of("tool_use"))) {
                    List toolCallConversation = this.handleToolCalls(prompt, chatResponse);
                    return this.internalStream(new Prompt(toolCallConversation, prompt.getOptions()), chatResponse);
                }
                return Mono.just((Object)chatResponse);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(chatResponseFlux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private ChatResponse toChatResponse(AnthropicApi.ChatCompletionResponse chatCompletion, Usage usage) {
        List<AnthropicApi.ContentBlock> toolToUseList;
        if (chatCompletion == null) {
            logger.warn("Null chat completion returned");
            return new ChatResponse(List.of());
        }
        List<Generation> generations = chatCompletion.content().stream().filter(content -> content.type() != AnthropicApi.ContentBlock.Type.TOOL_USE).map(content -> new Generation(new AssistantMessage(content.text(), Map.of()), ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build())).toList();
        ArrayList<Generation> allGenerations = new ArrayList<Generation>(generations);
        if (chatCompletion.stopReason() != null && generations.isEmpty()) {
            Generation generation = new Generation(new AssistantMessage(null, Map.of()), ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build());
            allGenerations.add(generation);
        }
        if (!CollectionUtils.isEmpty(toolToUseList = chatCompletion.content().stream().filter(c -> c.type() == AnthropicApi.ContentBlock.Type.TOOL_USE).toList())) {
            ArrayList<AssistantMessage.ToolCall> toolCalls = new ArrayList<AssistantMessage.ToolCall>();
            for (AnthropicApi.ContentBlock toolToUse : toolToUseList) {
                String functionCallId = toolToUse.id();
                String functionName = toolToUse.name();
                String functionArguments = ModelOptionsUtils.toJsonString(toolToUse.input());
                toolCalls.add(new AssistantMessage.ToolCall(functionCallId, "function", functionName, functionArguments));
            }
            AssistantMessage assistantMessage = new AssistantMessage("", Map.of(), toolCalls);
            Generation toolCallGeneration = new Generation(assistantMessage, ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build());
            allGenerations.add(toolCallGeneration);
        }
        return new ChatResponse(allGenerations, this.from(chatCompletion, usage));
    }

    private ChatResponseMetadata from(AnthropicApi.ChatCompletionResponse result) {
        return this.from(result, AnthropicUsage.from(result.usage()));
    }

    private ChatResponseMetadata from(AnthropicApi.ChatCompletionResponse result, Usage usage) {
        Assert.notNull((Object)result, (String)"Anthropic ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.id()).model(result.model()).usage(usage).keyValue("stop-reason", (Object)result.stopReason()).keyValue("stop-sequence", (Object)result.stopSequence()).keyValue("type", (Object)result.type()).build();
    }

    private String fromMediaData(Object mediaData) {
        if (mediaData instanceof byte[]) {
            byte[] bytes = (byte[])mediaData;
            return Base64.getEncoder().encodeToString(bytes);
        }
        if (mediaData instanceof String) {
            String text = (String)mediaData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaData.getClass().getSimpleName());
    }

    private AnthropicApi.ContentBlock.Type getContentBlockTypeByMedia(Media media) {
        String mimeType = media.getMimeType().toString();
        if (mimeType.startsWith("image")) {
            return AnthropicApi.ContentBlock.Type.IMAGE;
        }
        if (mimeType.contains("pdf")) {
            return AnthropicApi.ContentBlock.Type.DOCUMENT;
        }
        throw new IllegalArgumentException("Unsupported media type: " + mimeType + ". Supported types are: images (image/*) and PDF documents (application/pdf)");
    }

    AnthropicApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        HashSet<String> functionsForThisRequest = new HashSet<String>();
        List<AnthropicApi.AnthropicMessage> userMessages = prompt.getInstructions().stream().filter(message -> message.getMessageType() != MessageType.SYSTEM).map(message -> {
            if (message.getMessageType() == MessageType.USER) {
                UserMessage userMessage;
                ArrayList<AnthropicApi.ContentBlock> contents = new ArrayList<AnthropicApi.ContentBlock>(List.of(new AnthropicApi.ContentBlock(message.getText())));
                if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                    List<AnthropicApi.ContentBlock> mediaContent = userMessage.getMedia().stream().map(media -> {
                        AnthropicApi.ContentBlock.Type contentBlockType = this.getContentBlockTypeByMedia((Media)media);
                        AnthropicApi.ContentBlock.Source source = new AnthropicApi.ContentBlock.Source(media.getMimeType().toString(), this.fromMediaData(media.getData()));
                        return new AnthropicApi.ContentBlock(contentBlockType, source);
                    }).toList();
                    contents.addAll(mediaContent);
                }
                return new AnthropicApi.AnthropicMessage(contents, AnthropicApi.Role.valueOf(message.getMessageType().name()));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                ArrayList<AnthropicApi.ContentBlock> contentBlocks = new ArrayList<AnthropicApi.ContentBlock>();
                if (StringUtils.hasText((String)message.getText())) {
                    contentBlocks.add(new AnthropicApi.ContentBlock(message.getText()));
                }
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
                        contentBlocks.add(new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.TOOL_USE, toolCall.id(), toolCall.name(), ModelOptionsUtils.jsonToMap((String)toolCall.arguments())));
                    }
                }
                return new AnthropicApi.AnthropicMessage(contentBlocks, AnthropicApi.Role.ASSISTANT);
            }
            if (message.getMessageType() == MessageType.TOOL) {
                List<AnthropicApi.ContentBlock> toolResponses = ((ToolResponseMessage)message).getResponses().stream().map(toolResponse -> new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.TOOL_RESULT, toolResponse.id(), toolResponse.responseData())).toList();
                return new AnthropicApi.AnthropicMessage(toolResponses, AnthropicApi.Role.USER);
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.getMessageType()));
        }).toList();
        String systemPrompt = prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).map(m -> m.getText()).collect(Collectors.joining(System.lineSeparator()));
        AnthropicApi.ChatCompletionRequest request = new AnthropicApi.ChatCompletionRequest(this.defaultOptions.getModel(), userMessages, systemPrompt, this.defaultOptions.getMaxTokens(), this.defaultOptions.getTemperature(), stream);
        if (prompt.getOptions() != null) {
            AnthropicChatOptions updatedRuntimeOptions;
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof FunctionCallingOptions) {
                FunctionCallingOptions functionCallingOptions = (FunctionCallingOptions)chatOptions;
                updatedRuntimeOptions = (AnthropicChatOptions)ModelOptionsUtils.copyToTarget((Object)functionCallingOptions, FunctionCallingOptions.class, AnthropicChatOptions.class);
            } else {
                updatedRuntimeOptions = (AnthropicChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, AnthropicChatOptions.class);
            }
            functionsForThisRequest.addAll(this.runtimeFunctionCallbackConfigurations(updatedRuntimeOptions));
            request = (AnthropicApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, AnthropicApi.ChatCompletionRequest.class);
        }
        if (!CollectionUtils.isEmpty(this.defaultOptions.getFunctions())) {
            functionsForThisRequest.addAll(this.defaultOptions.getFunctions());
        }
        request = (AnthropicApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, AnthropicApi.ChatCompletionRequest.class);
        if (!CollectionUtils.isEmpty(functionsForThisRequest)) {
            List<AnthropicApi.Tool> tools = this.getFunctionTools(functionsForThisRequest);
            request = AnthropicApi.ChatCompletionRequest.from(request).withTools(tools).build();
        }
        return request;
    }

    private List<AnthropicApi.Tool> getFunctionTools(Set<String> functionNames) {
        return this.resolveFunctionCallbacks(functionNames).stream().map(functionCallback -> {
            String description = functionCallback.getDescription();
            String name = functionCallback.getName();
            String inputSchema = functionCallback.getInputTypeSchema();
            return new AnthropicApi.Tool(name, description, ModelOptionsUtils.jsonToMap((String)inputSchema));
        }).toList();
    }

    private ChatOptions buildRequestOptions(AnthropicApi.ChatCompletionRequest request) {
        return ChatOptions.builder().model(request.model()).maxTokens(request.maxTokens()).stopSequences(request.stopSequences()).temperature(request.temperature()).topK(request.topK()).topP(request.topP()).build();
    }

    public ChatOptions getDefaultOptions() {
        return AnthropicChatOptions.fromOptions(this.defaultOptions);
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

