/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AnthropicChatOptions
implements FunctionCallingOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="metadata")
    private AnthropicApi.ChatCompletionRequest.Metadata metadata;
    @JsonProperty(value="stop_sequences")
    private List<String> stopSequences;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonIgnore
    private Boolean proxyToolCalls;
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static Builder builder() {
        return new Builder();
    }

    public static AnthropicChatOptions fromOptions(AnthropicChatOptions fromOptions) {
        return AnthropicChatOptions.builder().model(fromOptions.getModel()).maxTokens(fromOptions.getMaxTokens()).metadata(fromOptions.getMetadata()).stopSequences(fromOptions.getStopSequences()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).topK(fromOptions.getTopK()).functionCallbacks(fromOptions.getFunctionCallbacks()).functions(fromOptions.getFunctions()).proxyToolCalls(fromOptions.getProxyToolCalls()).toolContext(fromOptions.getToolContext()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public AnthropicApi.ChatCompletionRequest.Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(AnthropicApi.ChatCompletionRequest.Metadata metadata) {
        this.metadata = metadata;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        Assert.notNull(functionCallbacks, (String)"FunctionCallbacks must not be null");
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        Assert.notNull(functions, (String)"Function must not be null");
        this.functions = functions;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public AnthropicChatOptions copy() {
        return AnthropicChatOptions.fromOptions(this);
    }

    public static class Builder {
        private final AnthropicChatOptions options = new AnthropicChatOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder model(AnthropicApi.ChatModel model) {
            this.options.model = model.getValue();
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder metadata(AnthropicApi.ChatCompletionRequest.Metadata metadata) {
            this.options.metadata = metadata;
            return this;
        }

        public Builder stopSequences(List<String> stopSequences) {
            this.options.stopSequences = stopSequences;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder functions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder function(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public Builder proxyToolCalls(Boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(String model) {
            return this.model(model);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(AnthropicApi.ChatModel model) {
            return this.model(model);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMaxTokens(Integer maxTokens) {
            return this.maxTokens(maxTokens);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMetadata(AnthropicApi.ChatCompletionRequest.Metadata metadata) {
            return this.metadata(metadata);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withStopSequences(List<String> stopSequences) {
            return this.stopSequences(stopSequences);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTemperature(Double temperature) {
            return this.temperature(temperature);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopP(Double topP) {
            return this.topP(topP);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopK(Integer topK) {
            return this.topK(topK);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            return this.functionCallbacks(functionCallbacks);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctions(Set<String> functionNames) {
            return this.functions(functionNames);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunction(String functionName) {
            return this.function(functionName);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withProxyToolCalls(Boolean proxyToolCalls) {
            return this.proxyToolCalls(proxyToolCalls);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withToolContext(Map<String, Object> toolContext) {
            return this.toolContext(toolContext);
        }

        public AnthropicChatOptions build() {
            return this.options;
        }
    }
}

