/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic.metadata;

import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.util.Assert;

public class AnthropicUsage
implements Usage {
    private final AnthropicApi.Usage usage;

    protected AnthropicUsage(AnthropicApi.Usage usage) {
        Assert.notNull((Object)usage, (String)"AnthropicApi Usage must not be null");
        this.usage = usage;
    }

    public static AnthropicUsage from(AnthropicApi.Usage usage) {
        return new AnthropicUsage(usage);
    }

    protected AnthropicApi.Usage getUsage() {
        return this.usage;
    }

    public Long getPromptTokens() {
        return this.getUsage().inputTokens().longValue();
    }

    public Long getGenerationTokens() {
        return this.getUsage().outputTokens().longValue();
    }

    public Long getTotalTokens() {
        return this.getPromptTokens() + this.getGenerationTokens();
    }

    public String toString() {
        return this.getUsage().toString();
    }
}

