/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock;

import org.springframework.ai.bedrock.api.AbstractBedrockApi;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.util.Assert;

public class BedrockUsage
implements Usage {
    private final AbstractBedrockApi.AmazonBedrockInvocationMetrics usage;

    public static BedrockUsage from(AbstractBedrockApi.AmazonBedrockInvocationMetrics usage) {
        return new BedrockUsage(usage);
    }

    protected BedrockUsage(AbstractBedrockApi.AmazonBedrockInvocationMetrics usage) {
        Assert.notNull((Object)usage, (String)"OpenAI Usage must not be null");
        this.usage = usage;
    }

    protected AbstractBedrockApi.AmazonBedrockInvocationMetrics getUsage() {
        return this.usage;
    }

    public Long getPromptTokens() {
        return (long)this.getUsage().inputTokenCount();
    }

    public Long getGenerationTokens() {
        return (long)this.getUsage().outputTokenCount();
    }

    public String toString() {
        return this.getUsage().toString();
    }
}

