/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.titan.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import org.springframework.ai.bedrock.api.AbstractBedrockApi;
import org.springframework.ai.model.ChatModelDescription;
import reactor.core.publisher.Flux;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class TitanChatBedrockApi
extends AbstractBedrockApi<TitanChatRequest, TitanChatResponse, TitanChatResponseChunk> {
    public TitanChatBedrockApi(String modelId, String region) {
        super(modelId, region);
    }

    public TitanChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper) {
        super(modelId, credentialsProvider, region, objectMapper);
    }

    public TitanChatBedrockApi(String modelId, String region, Duration timeout) {
        super(modelId, region, timeout);
    }

    public TitanChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    public TitanChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, Region region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    @Override
    public TitanChatResponse chatCompletion(TitanChatRequest request) {
        return this.internalInvocation(request, TitanChatResponse.class);
    }

    @Override
    public Flux<TitanChatResponseChunk> chatCompletionStream(TitanChatRequest request) {
        return this.internalInvocationStream(request, TitanChatResponseChunk.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TitanChatResponse(@JsonProperty(value="inputTextTokenCount") Integer inputTextTokenCount, @JsonProperty(value="results") List<Result> results) {

        public static enum CompletionReason {
            FINISH,
            LENGTH,
            CONTENT_FILTERED;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Result(@JsonProperty(value="tokenCount") Integer tokenCount, @JsonProperty(value="outputText") String outputText, @JsonProperty(value="completionReason") CompletionReason completionReason) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TitanChatResponseChunk(@JsonProperty(value="outputText") String outputText, @JsonProperty(value="index") Integer index, @JsonProperty(value="inputTextTokenCount") Integer inputTextTokenCount, @JsonProperty(value="totalOutputTextTokenCount") Integer totalOutputTextTokenCount, @JsonProperty(value="completionReason") TitanChatResponse.CompletionReason completionReason, @JsonProperty(value="amazon-bedrock-invocationMetrics") AbstractBedrockApi.AmazonBedrockInvocationMetrics amazonBedrockInvocationMetrics) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TitanChatRequest(@JsonProperty(value="inputText") String inputText, @JsonProperty(value="textGenerationConfig") TextGenerationConfig textGenerationConfig) {
        public static Builder builder(String inputText) {
            return new Builder(inputText);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record TextGenerationConfig(@JsonProperty(value="temperature") Float temperature, @JsonProperty(value="topP") Float topP, @JsonProperty(value="maxTokenCount") Integer maxTokenCount, @JsonProperty(value="stopSequences") List<String> stopSequences) {
        }

        public static class Builder {
            private final String inputText;
            private Float temperature;
            private Float topP;
            private Integer maxTokenCount;
            private List<String> stopSequences;

            public Builder(String inputText) {
                this.inputText = inputText;
            }

            public Builder withTemperature(Float temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder withTopP(Float topP) {
                this.topP = topP;
                return this;
            }

            public Builder withMaxTokenCount(Integer maxTokenCount) {
                this.maxTokenCount = maxTokenCount;
                return this;
            }

            public Builder withStopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public TitanChatRequest build() {
                if (this.temperature == null && this.topP == null && this.maxTokenCount == null && this.stopSequences == null) {
                    return new TitanChatRequest(this.inputText, null);
                }
                return new TitanChatRequest(this.inputText, new TextGenerationConfig(this.temperature, this.topP, this.maxTokenCount, this.stopSequences));
            }
        }
    }

    public static enum TitanChatModel implements ChatModelDescription
    {
        TITAN_TEXT_LITE_V1("amazon.titan-text-lite-v1"),
        TITAN_TEXT_EXPRESS_V1("amazon.titan-text-express-v1"),
        TITAN_TEXT_PREMIER_V1("amazon.titan-text-premier-v1:0");

        private final String id;

        public String id() {
            return this.id;
        }

        private TitanChatModel(String value) {
            this.id = value;
        }

        public String getName() {
            return this.id;
        }
    }
}

