/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.document;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.content.Media;
import org.springframework.ai.document.ContentFormatter;
import org.springframework.ai.document.DefaultContentFormatter;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.document.id.IdGenerator;
import org.springframework.ai.document.id.RandomIdGenerator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonIgnoreProperties(value={"contentFormatter", "embedding"})
public class Document {
    public static final ContentFormatter DEFAULT_CONTENT_FORMATTER = DefaultContentFormatter.defaultConfig();
    private final String id;
    private final String text;
    private final Media media;
    private final Map<String, Object> metadata;
    @Nullable
    private final Double score;
    @JsonIgnore
    private ContentFormatter contentFormatter = DEFAULT_CONTENT_FORMATTER;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Document(@JsonProperty(value="content") String content) {
        this(content, new HashMap<String, Object>());
    }

    public Document(String text, Map<String, Object> metadata) {
        this(new RandomIdGenerator().generateId(new Object[0]), text, null, metadata, null);
    }

    public Document(String id, String text, Map<String, Object> metadata) {
        this(id, text, null, metadata, null);
    }

    public Document(Media media, Map<String, Object> metadata) {
        this(new RandomIdGenerator().generateId(new Object[0]), null, media, metadata, null);
    }

    public Document(String id, Media media, Map<String, Object> metadata) {
        this(id, null, media, metadata, null);
    }

    private Document(String id, String text, Media media, Map<String, Object> metadata, @Nullable Double score) {
        Assert.hasText((String)id, (String)"id cannot be null or empty");
        Assert.notNull(metadata, (String)"metadata cannot be null");
        Assert.noNullElements(metadata.keySet(), (String)"metadata cannot have null keys");
        Assert.noNullElements(metadata.values(), (String)"metadata cannot have null values");
        Assert.isTrue((boolean)(text != null ^ media != null), (String)"exactly one of text or media must be specified");
        this.id = id;
        this.text = text;
        this.media = media;
        this.metadata = new HashMap<String, Object>(metadata);
        this.score = score;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    public boolean isText() {
        return this.text != null;
    }

    @Nullable
    public Media getMedia() {
        return this.media;
    }

    @JsonIgnore
    public String getFormattedContent() {
        return this.getFormattedContent(MetadataMode.ALL);
    }

    public String getFormattedContent(MetadataMode metadataMode) {
        Assert.notNull((Object)((Object)metadataMode), (String)"Metadata mode must not be null");
        return this.contentFormatter.format(this, metadataMode);
    }

    public String getFormattedContent(ContentFormatter formatter, MetadataMode metadataMode) {
        Assert.notNull((Object)formatter, (String)"formatter must not be null");
        Assert.notNull((Object)((Object)metadataMode), (String)"Metadata mode must not be null");
        return formatter.format(this, metadataMode);
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public Double getScore() {
        return this.score;
    }

    public ContentFormatter getContentFormatter() {
        return this.contentFormatter;
    }

    public void setContentFormatter(ContentFormatter contentFormatter) {
        this.contentFormatter = contentFormatter;
    }

    public Builder mutate() {
        return new Builder().id(this.id).text(this.text).media(this.media).metadata(this.metadata).score(this.score);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.id, document.id) && Objects.equals(this.text, document.text) && Objects.equals(this.media, document.media) && Objects.equals(this.metadata, document.metadata) && Objects.equals(this.score, document.score);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.text, this.media, this.metadata, this.score);
    }

    public String toString() {
        return "Document{id='" + this.id + "', text='" + this.text + "', media='" + String.valueOf(this.media) + "', metadata=" + String.valueOf(this.metadata) + ", score=" + this.score + "}";
    }

    public static final class Builder {
        private String id;
        private String text;
        private Media media;
        private Map<String, Object> metadata = new HashMap<String, Object>();
        @Nullable
        private Double score;
        private IdGenerator idGenerator = new RandomIdGenerator();

        public Builder idGenerator(IdGenerator idGenerator) {
            Assert.notNull((Object)idGenerator, (String)"idGenerator cannot be null");
            this.idGenerator = idGenerator;
            return this;
        }

        public Builder id(String id) {
            Assert.hasText((String)id, (String)"id cannot be null or empty");
            this.id = id;
            return this;
        }

        public Builder text(@Nullable String text) {
            this.text = text;
            return this;
        }

        public Builder media(@Nullable Media media) {
            this.media = media;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            Assert.notNull(metadata, (String)"metadata cannot be null");
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(String key, Object value) {
            Assert.notNull((Object)key, (String)"metadata key cannot be null");
            Assert.notNull((Object)value, (String)"metadata value cannot be null");
            this.metadata.put(key, value);
            return this;
        }

        public Builder score(@Nullable Double score) {
            this.score = score;
            return this;
        }

        public Document build() {
            if (!StringUtils.hasText((String)this.id)) {
                this.id = this.idGenerator.generateId(this.text, this.metadata);
            }
            return new Document(this.id, this.text, this.media, this.metadata, this.score);
        }
    }
}

