/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.function.Consumer;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class MistralAiModerationApi {
    private static final String DEFAULT_BASE_URL = "https://api.mistral.ai";
    private final RestClient restClient;

    public MistralAiModerationApi(String mistralAiApiKey) {
        this(DEFAULT_BASE_URL, mistralAiApiKey, RestClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public MistralAiModerationApi(String baseUrl, String mistralAiApiKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Consumer<HttpHeaders> jsonContentHeaders = headers -> {
            headers.setBearerAuth(mistralAiApiKey);
            headers.setContentType(MediaType.APPLICATION_JSON);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(jsonContentHeaders).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<MistralAiModerationResponse> moderate(MistralAiModerationRequest mistralAiModerationRequest) {
        Assert.notNull((Object)mistralAiModerationRequest, (String)"Moderation request cannot be null.");
        Assert.hasLength((String)mistralAiModerationRequest.prompt(), (String)"Prompt cannot be empty.");
        Assert.notNull((Object)mistralAiModerationRequest.model(), (String)"Model cannot be null.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("v1/moderations", new Object[0])).body((Object)mistralAiModerationRequest).retrieve().toEntity(MistralAiModerationResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record MistralAiModerationRequest(@JsonProperty(value="input") String prompt, @JsonProperty(value="model") String model) {
        public MistralAiModerationRequest(String prompt) {
            this(prompt, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record MistralAiModerationResponse(@JsonProperty(value="id") String id, @JsonProperty(value="model") String model, @JsonProperty(value="results") MistralAiModerationResult[] results) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record CategoryScores(@JsonProperty(value="sexual") double sexual, @JsonProperty(value="hate_and_discrimination") double hateAndDiscrimination, @JsonProperty(value="violence_and_threats") double violenceAndThreats, @JsonProperty(value="selfharm") double selfHarm, @JsonProperty(value="dangerous_and_criminal_content") double dangerousAndCriminalContent, @JsonProperty(value="health") double health, @JsonProperty(value="financial") double financial, @JsonProperty(value="law") double law, @JsonProperty(value="pii") double pii) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Categories(@JsonProperty(value="sexual") boolean sexual, @JsonProperty(value="hate_and_discrimination") boolean hateAndDiscrimination, @JsonProperty(value="violence_and_threats") boolean violenceAndThreats, @JsonProperty(value="selfharm") boolean selfHarm, @JsonProperty(value="dangerous_and_criminal_content") boolean dangerousAndCriminalContent, @JsonProperty(value="health") boolean health, @JsonProperty(value="financial") boolean financial, @JsonProperty(value="law") boolean law, @JsonProperty(value="pii") boolean pii) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record MistralAiModerationResult(@JsonProperty(value="categories") Categories categories, @JsonProperty(value="category_scores") CategoryScores categoryScores) {
        public boolean flagged() {
            return this.categories != null && (this.categories.sexual() || this.categories.hateAndDiscrimination() || this.categories.violenceAndThreats() || this.categories.selfHarm() || this.categories.dangerousAndCriminalContent() || this.categories.health() || this.categories.financial() || this.categories.law() || this.categories.pii());
        }
    }

    public static enum Model {
        MISTRAL_MODERATION("mistral-moderation-latest");

        private final String value;

        private Model(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

