/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai.ocr;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class MistralOcrApi {
    private static final String DEFAULT_BASE_URL = "https://api.mistral.ai";
    private final RestClient restClient;

    public MistralOcrApi(String mistralAiApiKey) {
        this(DEFAULT_BASE_URL, mistralAiApiKey);
    }

    public MistralOcrApi(String baseUrl, String mistralAiApiKey) {
        this(baseUrl, mistralAiApiKey, RestClient.builder());
    }

    public MistralOcrApi(String baseUrl, String mistralAiApiKey, RestClient.Builder restClientBuilder) {
        this(baseUrl, mistralAiApiKey, restClientBuilder, RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public MistralOcrApi(String baseUrl, String mistralAiApiKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Consumer<HttpHeaders> jsonContentHeaders = headers -> {
            headers.setBearerAuth(mistralAiApiKey);
            headers.setContentType(MediaType.APPLICATION_JSON);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(jsonContentHeaders).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<OCRResponse> ocr(OCRRequest ocrRequest) {
        Assert.notNull((Object)ocrRequest, (String)"The request body can not be null.");
        Assert.notNull((Object)ocrRequest.model(), (String)"The model can not be null.");
        Assert.notNull((Object)ocrRequest.document(), (String)"The document can not be null.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/ocr", new Object[0])).body((Object)ocrRequest).retrieve().toEntity(OCRResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OCRRequest(@JsonProperty(value="model") String model, @JsonProperty(value="id") String id, @JsonProperty(value="document") Document document, @JsonProperty(value="pages") List<Integer> pages, @JsonProperty(value="include_image_base64") Boolean includeImageBase64, @JsonProperty(value="image_limit") Integer imageLimit, @JsonProperty(value="image_min_size") Integer imageMinSize) {
        public OCRRequest(String model, Document document) {
            this(model, null, document, null, null, null, null);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static interface Document {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ImageURLChunk(@JsonProperty(value="type") String type, @JsonProperty(value="image_url") String imageUrl, @JsonProperty(value="image_name") String imageName) implements Document
        {
            public ImageURLChunk(String imageUrl) {
                this("image_url", imageUrl, null);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentURLChunk(@JsonProperty(value="type") String type, @JsonProperty(value="document_url") String documentUrl, @JsonProperty(value="document_name") String documentName) implements Document
        {
            public DocumentURLChunk(String documentUrl) {
                this("document_url", documentUrl, null);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OCRResponse(@JsonProperty(value="pages") List<OCRPage> pages, @JsonProperty(value="model") String model, @JsonProperty(value="usage_info") OCRUsageInfo usageInfo, @JsonProperty(value="pages_processed") Integer pagesProcessed, @JsonProperty(value="doc_size_bytes") Integer docSizeBytes) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OCRUsageInfo(@JsonProperty(value="pages_processed") Integer pagesProcessed, @JsonProperty(value="doc_size_bytes") Integer docSizeBytes) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OCRPageDimensions(@JsonProperty(value="dpi") Integer dpi, @JsonProperty(value="height") Integer height, @JsonProperty(value="width") Integer width) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ExtractedImage(@JsonProperty(value="id") String id, @JsonProperty(value="top_left_x") Integer topLeftX, @JsonProperty(value="top_left_y") Integer topLeftY, @JsonProperty(value="bottom_right_x") Integer bottomRightX, @JsonProperty(value="bottom_right_y") Integer bottomRightY, @JsonProperty(value="image_base64") String imageBase64) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExtractedImage)) {
                return false;
            }
            ExtractedImage that = (ExtractedImage)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.topLeftX, that.topLeftX) && Objects.equals(this.topLeftY, that.topLeftY) && Objects.equals(this.bottomRightX, that.bottomRightX) && Objects.equals(this.bottomRightY, that.bottomRightY) && Objects.equals(this.imageBase64, that.imageBase64);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.id, this.topLeftX, this.topLeftY, this.bottomRightX, this.bottomRightY, this.imageBase64);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OCRPage(@JsonProperty(value="index") Integer index, @JsonProperty(value="markdown") String markdown, @JsonProperty(value="images") List<ExtractedImage> images, @JsonProperty(value="dimensions") OCRPageDimensions dimensions) {
    }

    public static enum OCRModel {
        MISTRAL_OCR_LATEST("mistral-ocr-latest");

        private final String value;

        private OCRModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

