/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai.moderation;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mistralai.api.MistralAiModerationApi;
import org.springframework.ai.mistralai.moderation.MistralAiModerationOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.moderation.Categories;
import org.springframework.ai.moderation.CategoryScores;
import org.springframework.ai.moderation.Generation;
import org.springframework.ai.moderation.Moderation;
import org.springframework.ai.moderation.ModerationModel;
import org.springframework.ai.moderation.ModerationOptions;
import org.springframework.ai.moderation.ModerationPrompt;
import org.springframework.ai.moderation.ModerationResponse;
import org.springframework.ai.moderation.ModerationResult;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class MistralAiModerationModel
implements ModerationModel {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MistralAiModerationApi mistralAiModerationApi;
    private final RetryTemplate retryTemplate;
    private final MistralAiModerationOptions defaultOptions;

    public MistralAiModerationModel(MistralAiModerationApi mistralAiModerationApi, RetryTemplate retryTemplate, MistralAiModerationOptions options) {
        Assert.notNull((Object)mistralAiModerationApi, (String)"mistralAiModerationApi must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        this.mistralAiModerationApi = mistralAiModerationApi;
        this.retryTemplate = retryTemplate;
        this.defaultOptions = options;
    }

    public ModerationResponse call(ModerationPrompt moderationPrompt) {
        return (ModerationResponse)this.retryTemplate.execute(ctx -> {
            String instructions = moderationPrompt.getInstructions().getText();
            MistralAiModerationApi.MistralAiModerationRequest moderationRequest = new MistralAiModerationApi.MistralAiModerationRequest(instructions);
            moderationRequest = this.defaultOptions != null ? (MistralAiModerationApi.MistralAiModerationRequest)ModelOptionsUtils.merge((Object)this.defaultOptions, (Object)moderationRequest, MistralAiModerationApi.MistralAiModerationRequest.class) : (MistralAiModerationApi.MistralAiModerationRequest)ModelOptionsUtils.merge((Object)this.toMistralAiModerationOptions(moderationPrompt.getOptions()), (Object)moderationRequest, MistralAiModerationApi.MistralAiModerationRequest.class);
            ResponseEntity<MistralAiModerationApi.MistralAiModerationResponse> moderationResponseEntity = this.mistralAiModerationApi.moderate(moderationRequest);
            return this.convertResponse(moderationResponseEntity, moderationRequest);
        });
    }

    private ModerationResponse convertResponse(ResponseEntity<MistralAiModerationApi.MistralAiModerationResponse> moderationResponseEntity, MistralAiModerationApi.MistralAiModerationRequest mistralAiModerationRequest) {
        MistralAiModerationApi.MistralAiModerationResponse moderationApiResponse = (MistralAiModerationApi.MistralAiModerationResponse)moderationResponseEntity.getBody();
        if (moderationApiResponse == null) {
            this.logger.warn("No moderation response returned for request: {}", (Object)mistralAiModerationRequest);
            return new ModerationResponse(new Generation());
        }
        ArrayList<ModerationResult> moderationResults = new ArrayList<ModerationResult>();
        if (moderationApiResponse.results() != null) {
            for (MistralAiModerationApi.MistralAiModerationResult result : moderationApiResponse.results()) {
                Categories categories = null;
                CategoryScores categoryScores = null;
                if (result.categories() != null) {
                    categories = Categories.builder().sexual(result.categories().sexual()).pii(result.categories().pii()).law(result.categories().law()).financial(result.categories().financial()).health(result.categories().health()).dangerousAndCriminalContent(result.categories().dangerousAndCriminalContent()).violence(result.categories().violenceAndThreats()).hate(result.categories().hateAndDiscrimination()).selfHarm(result.categories().selfHarm()).build();
                }
                if (result.categoryScores() != null) {
                    categoryScores = CategoryScores.builder().sexual(result.categoryScores().sexual()).pii(result.categoryScores().pii()).law(result.categoryScores().law()).financial(result.categoryScores().financial()).health(result.categoryScores().health()).dangerousAndCriminalContent(result.categoryScores().dangerousAndCriminalContent()).violence(result.categoryScores().violenceAndThreats()).hate(result.categoryScores().hateAndDiscrimination()).selfHarm(result.categoryScores().selfHarm()).build();
                }
                ModerationResult moderationResult = ModerationResult.builder().categories(categories).categoryScores(categoryScores).flagged(result.flagged()).build();
                moderationResults.add(moderationResult);
            }
        }
        Moderation moderation = Moderation.builder().id(moderationApiResponse.id()).model(moderationApiResponse.model()).results(moderationResults).build();
        return new ModerationResponse(new Generation(moderation));
    }

    private MistralAiModerationOptions toMistralAiModerationOptions(ModerationOptions runtimeModerationOptions) {
        MistralAiModerationOptions.Builder mistralAiModerationOptionsBuilder = MistralAiModerationOptions.builder();
        if (runtimeModerationOptions != null && runtimeModerationOptions.getModel() != null) {
            mistralAiModerationOptionsBuilder.model(runtimeModerationOptions.getModel());
        }
        return mistralAiModerationOptionsBuilder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MistralAiModerationApi mistralAiModerationApi;
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        private MistralAiModerationOptions options = MistralAiModerationOptions.builder().model(MistralAiModerationApi.Model.MISTRAL_MODERATION.getValue()).build();

        public Builder mistralAiModerationApi(MistralAiModerationApi mistralAiModerationApi) {
            this.mistralAiModerationApi = mistralAiModerationApi;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public Builder options(MistralAiModerationOptions options) {
            this.options = options;
            return this;
        }

        public MistralAiModerationModel build() {
            return new MistralAiModerationModel(this.mistralAiModerationApi, this.retryTemplate, this.options);
        }
    }
}

