/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.tool;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.model.tool.DefaultToolExecutionResult;

public interface ToolExecutionResult {
    public static final String FINISH_REASON = "returnDirect";
    public static final String METADATA_TOOL_ID = "toolId";
    public static final String METADATA_TOOL_NAME = "toolName";

    public List<Message> conversationHistory();

    default public boolean returnDirect() {
        return false;
    }

    public static DefaultToolExecutionResult.Builder builder() {
        return DefaultToolExecutionResult.builder();
    }

    public static List<Generation> buildGenerations(ToolExecutionResult toolExecutionResult) {
        List<Message> conversationHistory = toolExecutionResult.conversationHistory();
        ArrayList<Generation> generations = new ArrayList<Generation>();
        Message message = conversationHistory.get(conversationHistory.size() - 1);
        if (message instanceof ToolResponseMessage) {
            ToolResponseMessage toolResponseMessage = (ToolResponseMessage)message;
            toolResponseMessage.getResponses().forEach(response -> {
                AssistantMessage assistantMessage = new AssistantMessage(response.responseData());
                Generation generation = new Generation(assistantMessage, ChatGenerationMetadata.builder().metadata(METADATA_TOOL_ID, response.id()).metadata(METADATA_TOOL_NAME, response.name()).finishReason(FINISH_REASON).build());
                generations.add(generation);
            });
        }
        return generations;
    }
}

