/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.aot;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public abstract class AiRuntimeHints {
    private static final Logger log = LoggerFactory.getLogger(AiRuntimeHints.class);

    public static Set<TypeReference> findJsonAnnotatedClassesInPackage(String packageName) {
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(JsonInclude.class);
        TypeFilter typeFilter = (metadataReader, metadataReaderFactory) -> {
            try {
                Class<?> clazz = Class.forName(metadataReader.getClassMetadata().getClassName());
                return annotationTypeFilter.match(metadataReader, metadataReaderFactory) || !AiRuntimeHints.discoverJacksonAnnotatedTypesFromRootType(clazz).isEmpty();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        return AiRuntimeHints.findClassesInPackage(packageName, typeFilter);
    }

    public static Set<TypeReference> findJsonAnnotatedClassesInPackage(Class<?> packageClass) {
        return AiRuntimeHints.findJsonAnnotatedClassesInPackage(packageClass.getPackageName());
    }

    public static Set<TypeReference> findClassesInPackage(String packageName, TypeFilter typeFilter) {
        ClassPathScanningCandidateComponentProvider classPathScanningCandidateComponentProvider = new ClassPathScanningCandidateComponentProvider(false);
        classPathScanningCandidateComponentProvider.addIncludeFilter(typeFilter);
        return classPathScanningCandidateComponentProvider.findCandidateComponents(packageName).stream().map(bd -> TypeReference.of((String)Objects.requireNonNull(bd.getBeanClassName()))).peek(tr -> {
            if (log.isDebugEnabled()) {
                log.debug("registering [{}]", (Object)tr.getName());
            }
        }).collect(Collectors.toUnmodifiableSet());
    }

    private static boolean hasJacksonAnnotations(Class<?> type) {
        Set<Class<JsonInclude>> annotationsToFind = Set.of(JsonProperty.class, JsonInclude.class);
        for (Class<JsonInclude> annotationToFind : annotationsToFind) {
            if (type.isAnnotationPresent(annotationToFind)) {
                return true;
            }
            HashSet<Executable> executables = new HashSet<Executable>();
            executables.addAll(Set.of(type.getMethods()));
            executables.addAll(Set.of(type.getConstructors()));
            executables.addAll(Set.of(type.getDeclaredConstructors()));
            for (Executable executable : executables) {
                if (executable.isAnnotationPresent(annotationToFind)) {
                    return true;
                }
                for (Parameter p : executable.getParameters()) {
                    if (!p.isAnnotationPresent(annotationToFind)) continue;
                    return true;
                }
            }
            if (type.getRecordComponents() != null) {
                for (AnnotatedElement annotatedElement : type.getRecordComponents()) {
                    if (!annotatedElement.isAnnotationPresent(annotationToFind)) continue;
                    return true;
                }
            }
            for (AnnotatedElement annotatedElement : type.getFields()) {
                if (!((AccessibleObject)annotatedElement).isAnnotationPresent(annotationToFind)) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<Class<?>> discoverJacksonAnnotatedTypesFromRootType(Class<?> type) {
        HashSet jsonTypes = new HashSet();
        HashSet classesToInspect = new HashSet();
        classesToInspect.add(type);
        classesToInspect.addAll(Arrays.asList(type.getNestMembers()));
        for (Class clazz : classesToInspect) {
            if (!AiRuntimeHints.hasJacksonAnnotations(clazz)) continue;
            jsonTypes.add(clazz);
        }
        return jsonTypes;
    }

    public static Set<TypeReference> findInnerClassesFor(Class<?> clazz) {
        HashSet<String> indent = new HashSet<String>();
        AiRuntimeHints.findNestedClasses(clazz, indent);
        return indent.stream().map(TypeReference::of).collect(Collectors.toSet());
    }

    private static void findNestedClasses(Class<?> clazz, Set<String> indent) {
        ArrayList classes = new ArrayList();
        classes.addAll(Arrays.asList(clazz.getDeclaredClasses()));
        classes.addAll(Arrays.asList(clazz.getClasses()));
        for (Class clazz2 : classes) {
            AiRuntimeHints.findNestedClasses(clazz2, indent);
        }
        indent.addAll(classes.stream().map(Class::getName).toList());
    }
}

