/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.model;

import java.util.Objects;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.model.ModelResult;

public class Generation
implements ModelResult<AssistantMessage> {
    private final AssistantMessage assistantMessage;
    private ChatGenerationMetadata chatGenerationMetadata;

    public Generation(AssistantMessage assistantMessage) {
        this(assistantMessage, ChatGenerationMetadata.NULL);
    }

    public Generation(AssistantMessage assistantMessage, ChatGenerationMetadata chatGenerationMetadata) {
        this.assistantMessage = assistantMessage;
        this.chatGenerationMetadata = chatGenerationMetadata;
    }

    @Override
    public AssistantMessage getOutput() {
        return this.assistantMessage;
    }

    @Override
    public ChatGenerationMetadata getMetadata() {
        ChatGenerationMetadata chatGenerationMetadata = this.chatGenerationMetadata;
        return chatGenerationMetadata != null ? chatGenerationMetadata : ChatGenerationMetadata.NULL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Generation)) {
            return false;
        }
        Generation that = (Generation)o;
        return Objects.equals(this.assistantMessage, that.assistantMessage) && Objects.equals(this.chatGenerationMetadata, that.chatGenerationMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.assistantMessage, this.chatGenerationMetadata);
    }

    public String toString() {
        return "Generation[assistantMessage=" + String.valueOf(this.assistantMessage) + ", chatGenerationMetadata=" + String.valueOf(this.chatGenerationMetadata) + "]";
    }
}

