/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama;

import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.ai.ollama.api.OllamaEmbeddingOptions;
import org.springframework.ai.ollama.api.OllamaModel;
import org.springframework.ai.ollama.api.OllamaOptions;
import org.springframework.ai.ollama.api.common.OllamaApiConstants;
import org.springframework.ai.ollama.management.ModelManagementOptions;
import org.springframework.ai.ollama.management.OllamaModelManager;
import org.springframework.ai.ollama.management.PullModelStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OllamaEmbeddingModel
extends AbstractEmbeddingModel {
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private final OllamaApi ollamaApi;
    private final OllamaEmbeddingOptions defaultOptions;
    private final ObservationRegistry observationRegistry;
    private final OllamaModelManager modelManager;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public OllamaEmbeddingModel(OllamaApi ollamaApi, OllamaEmbeddingOptions defaultOptions, ObservationRegistry observationRegistry, ModelManagementOptions modelManagementOptions) {
        Assert.notNull((Object)ollamaApi, (String)"ollamaApi must not be null");
        Assert.notNull((Object)defaultOptions, (String)"options must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        Assert.notNull((Object)modelManagementOptions, (String)"modelManagementOptions must not be null");
        this.ollamaApi = ollamaApi;
        this.defaultOptions = defaultOptions;
        this.observationRegistry = observationRegistry;
        this.modelManager = new OllamaModelManager(ollamaApi, modelManagementOptions);
        this.initializeModel(defaultOptions.getModel(), modelManagementOptions.pullModelStrategy());
    }

    public static Builder builder() {
        return new Builder();
    }

    public float[] embed(Document document) {
        return this.embed(document.getText());
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        Assert.notEmpty((Collection)request.getInstructions(), (String)"At least one text is required!");
        EmbeddingRequest embeddingRequest = this.buildEmbeddingRequest(request);
        OllamaApi.EmbeddingsRequest ollamaEmbeddingRequest = this.ollamaEmbeddingRequest(embeddingRequest);
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(request).provider(OllamaApiConstants.PROVIDER_NAME).build();
        return (EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            OllamaApi.EmbeddingsResponse response = this.ollamaApi.embed(ollamaEmbeddingRequest);
            AtomicInteger indexCounter = new AtomicInteger(0);
            List<Embedding> embeddings = response.embeddings().stream().map(e -> new Embedding(e, Integer.valueOf(indexCounter.getAndIncrement()))).toList();
            EmbeddingResponseMetadata embeddingResponseMetadata = new EmbeddingResponseMetadata(response.model(), (Usage)this.getDefaultUsage(response));
            EmbeddingResponse embeddingResponse = new EmbeddingResponse(embeddings, embeddingResponseMetadata);
            observationContext.setResponse((Object)embeddingResponse);
            return embeddingResponse;
        });
    }

    private DefaultUsage getDefaultUsage(OllamaApi.EmbeddingsResponse response) {
        return new DefaultUsage(Optional.ofNullable(response.promptEvalCount()).orElse(0), Integer.valueOf(0));
    }

    EmbeddingRequest buildEmbeddingRequest(EmbeddingRequest embeddingRequest) {
        OllamaEmbeddingOptions requestOptions;
        OllamaEmbeddingOptions runtimeOptions = null;
        if (embeddingRequest.getOptions() != null) {
            runtimeOptions = (OllamaEmbeddingOptions)ModelOptionsUtils.copyToTarget((Object)embeddingRequest.getOptions(), EmbeddingOptions.class, OllamaEmbeddingOptions.class);
        }
        if (!StringUtils.hasText((String)(requestOptions = (OllamaEmbeddingOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, OllamaEmbeddingOptions.class)).getModel())) {
            throw new IllegalArgumentException("model cannot be null or empty");
        }
        return new EmbeddingRequest(embeddingRequest.getInstructions(), (EmbeddingOptions)requestOptions);
    }

    OllamaApi.EmbeddingsRequest ollamaEmbeddingRequest(EmbeddingRequest embeddingRequest) {
        OllamaEmbeddingOptions requestOptions = null;
        requestOptions = embeddingRequest.getOptions() instanceof OllamaEmbeddingOptions ? (OllamaEmbeddingOptions)embeddingRequest.getOptions() : OllamaEmbeddingOptions.fromOptions((OllamaOptions)embeddingRequest.getOptions());
        return new OllamaApi.EmbeddingsRequest(requestOptions.getModel(), embeddingRequest.getInstructions(), DurationParser.parse(requestOptions.getKeepAlive()), OllamaEmbeddingOptions.filterNonSupportedFields(requestOptions.toMap()), requestOptions.getTruncate());
    }

    private void initializeModel(String model, PullModelStrategy pullModelStrategy) {
        if (pullModelStrategy != null && !PullModelStrategy.NEVER.equals((Object)pullModelStrategy)) {
            this.modelManager.pullModel(model, pullModelStrategy);
        }
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static final class Builder {
        private OllamaApi ollamaApi;
        private OllamaEmbeddingOptions defaultOptions = OllamaEmbeddingOptions.builder().model(OllamaModel.MXBAI_EMBED_LARGE.id()).build();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private ModelManagementOptions modelManagementOptions = ModelManagementOptions.defaults();

        private Builder() {
        }

        public Builder ollamaApi(OllamaApi ollamaApi) {
            this.ollamaApi = ollamaApi;
            return this;
        }

        @Deprecated
        public Builder defaultOptions(OllamaOptions defaultOptions) {
            this.defaultOptions = OllamaEmbeddingOptions.fromOptions(defaultOptions);
            return this;
        }

        public Builder defaultOptions(OllamaEmbeddingOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public Builder modelManagementOptions(ModelManagementOptions modelManagementOptions) {
            this.modelManagementOptions = modelManagementOptions;
            return this;
        }

        public OllamaEmbeddingModel build() {
            return new OllamaEmbeddingModel(this.ollamaApi, this.defaultOptions, this.observationRegistry, this.modelManagementOptions);
        }
    }

    public static class DurationParser {
        private static final Pattern PATTERN = Pattern.compile("(-?\\d+)(ms|s|m|h)");

        public static Duration parse(String input) {
            if (!StringUtils.hasText((String)input)) {
                return null;
            }
            Matcher matcher = PATTERN.matcher(input);
            if (matcher.matches()) {
                String unit;
                long value = Long.parseLong(matcher.group(1));
                return switch (unit = matcher.group(2)) {
                    case "ms" -> Duration.ofMillis(value);
                    case "s" -> Duration.ofSeconds(value);
                    case "m" -> Duration.ofMinutes(value);
                    case "h" -> Duration.ofHours(value);
                    default -> throw new IllegalArgumentException("Unsupported time unit: " + unit);
                };
            }
            throw new IllegalArgumentException("Invalid duration format: " + input);
        }
    }
}

