/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.metadata;

import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.util.Assert;

public class OpenAiUsage
implements Usage {
    private final OpenAiApi.Usage usage;

    public static OpenAiUsage from(OpenAiApi.Usage usage) {
        return new OpenAiUsage(usage);
    }

    protected OpenAiUsage(OpenAiApi.Usage usage) {
        Assert.notNull((Object)usage, (String)"OpenAI Usage must not be null");
        this.usage = usage;
    }

    protected OpenAiApi.Usage getUsage() {
        return this.usage;
    }

    public Long getPromptTokens() {
        Integer promptTokens = this.getUsage().promptTokens();
        return promptTokens != null ? promptTokens.longValue() : 0L;
    }

    public Long getGenerationTokens() {
        Integer generationTokens = this.getUsage().completionTokens();
        return generationTokens != null ? generationTokens.longValue() : 0L;
    }

    public Long getTotalTokens() {
        Integer totalTokens = this.getUsage().totalTokens();
        if (totalTokens != null) {
            return totalTokens.longValue();
        }
        return this.getPromptTokens() + this.getGenerationTokens();
    }

    public String toString() {
        return this.getUsage().toString();
    }
}

