/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.ResponseFormat;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAiChatOptions
implements ToolCallingChatOptions {
    private static final Logger logger = LoggerFactory.getLogger(OpenAiChatOptions.class);
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonProperty(value="logprobs")
    private Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    private Integer topLogprobs;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="max_completion_tokens")
    private Integer maxCompletionTokens;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="modalities")
    private List<String> outputModalities;
    @JsonProperty(value="audio")
    private OpenAiApi.ChatCompletionRequest.AudioParameters outputAudio;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="response_format")
    private ResponseFormat responseFormat;
    @JsonProperty(value="stream_options")
    private OpenAiApi.ChatCompletionRequest.StreamOptions streamOptions;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="tools")
    private List<OpenAiApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private Object toolChoice;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="parallel_tool_calls")
    private Boolean parallelToolCalls;
    @JsonProperty(value="store")
    private Boolean store;
    @JsonProperty(value="metadata")
    private Map<String, String> metadata;
    @JsonProperty(value="reasoning_effort")
    private String reasoningEffort;
    @JsonProperty(value="verbosity")
    private String verbosity;
    @JsonProperty(value="web_search_options")
    private OpenAiApi.ChatCompletionRequest.WebSearchOptions webSearchOptions;
    @JsonProperty(value="service_tier")
    private String serviceTier;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();

    public static Builder builder() {
        return new Builder();
    }

    public static OpenAiChatOptions fromOptions(OpenAiChatOptions fromOptions) {
        return OpenAiChatOptions.builder().model(fromOptions.getModel()).frequencyPenalty(fromOptions.getFrequencyPenalty()).logitBias(fromOptions.getLogitBias()).logprobs(fromOptions.getLogprobs()).topLogprobs(fromOptions.getTopLogprobs()).maxTokens(fromOptions.getMaxTokens()).maxCompletionTokens(fromOptions.getMaxCompletionTokens()).N(fromOptions.getN()).outputModalities((List<String>)(fromOptions.getOutputModalities() != null ? new ArrayList<String>(fromOptions.getOutputModalities()) : null)).outputAudio(fromOptions.getOutputAudio()).presencePenalty(fromOptions.getPresencePenalty()).responseFormat(fromOptions.getResponseFormat()).streamUsage(fromOptions.getStreamUsage()).seed(fromOptions.getSeed()).stop((List<String>)(fromOptions.getStop() != null ? new ArrayList<String>(fromOptions.getStop()) : null)).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).tools(fromOptions.getTools()).toolChoice(fromOptions.getToolChoice()).user(fromOptions.getUser()).parallelToolCalls(fromOptions.getParallelToolCalls()).toolCallbacks((List<ToolCallback>)(fromOptions.getToolCallbacks() != null ? new ArrayList<ToolCallback>(fromOptions.getToolCallbacks()) : null)).toolNames((Set<String>)(fromOptions.getToolNames() != null ? new HashSet<String>(fromOptions.getToolNames()) : null)).httpHeaders((Map<String, String>)(fromOptions.getHttpHeaders() != null ? new HashMap<String, String>(fromOptions.getHttpHeaders()) : null)).internalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).toolContext((Map<String, Object>)(fromOptions.getToolContext() != null ? new HashMap<String, Object>(fromOptions.getToolContext()) : null)).store(fromOptions.getStore()).metadata(fromOptions.getMetadata()).reasoningEffort(fromOptions.getReasoningEffort()).webSearchOptions(fromOptions.getWebSearchOptions()).verbosity(fromOptions.getVerbosity()).serviceTier(fromOptions.getServiceTier()).build();
    }

    public Boolean getStreamUsage() {
        return this.streamOptions != null;
    }

    public void setStreamUsage(Boolean enableStreamUsage) {
        this.streamOptions = enableStreamUsage != false ? OpenAiApi.ChatCompletionRequest.StreamOptions.INCLUDE_USAGE : null;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public void setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public List<String> getOutputModalities() {
        return this.outputModalities;
    }

    public void setOutputModalities(List<String> modalities) {
        this.outputModalities = modalities;
    }

    public OpenAiApi.ChatCompletionRequest.AudioParameters getOutputAudio() {
        return this.outputAudio;
    }

    public void setOutputAudio(OpenAiApi.ChatCompletionRequest.AudioParameters audio) {
        this.outputAudio = audio;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public OpenAiApi.ChatCompletionRequest.StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public void setStreamOptions(OpenAiApi.ChatCompletionRequest.StreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<OpenAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<OpenAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    @JsonIgnore
    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    @JsonIgnore
    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public Boolean getStore() {
        return this.store;
    }

    public void setStore(Boolean store) {
        this.store = store;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getReasoningEffort() {
        return this.reasoningEffort;
    }

    public void setReasoningEffort(String reasoningEffort) {
        this.reasoningEffort = reasoningEffort;
    }

    public OpenAiApi.ChatCompletionRequest.WebSearchOptions getWebSearchOptions() {
        return this.webSearchOptions;
    }

    public void setWebSearchOptions(OpenAiApi.ChatCompletionRequest.WebSearchOptions webSearchOptions) {
        this.webSearchOptions = webSearchOptions;
    }

    public String getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(String verbosity) {
        this.verbosity = verbosity;
    }

    public String getServiceTier() {
        return this.serviceTier;
    }

    public void setServiceTier(String serviceTier) {
        this.serviceTier = serviceTier;
    }

    public OpenAiChatOptions copy() {
        return OpenAiChatOptions.fromOptions(this);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.maxCompletionTokens, this.n, this.presencePenalty, this.responseFormat, this.streamOptions, this.seed, this.stop, this.temperature, this.topP, this.tools, this.toolChoice, this.user, this.parallelToolCalls, this.toolCallbacks, this.toolNames, this.httpHeaders, this.internalToolExecutionEnabled, this.toolContext, this.outputModalities, this.outputAudio, this.store, this.metadata, this.reasoningEffort, this.webSearchOptions, this.serviceTier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenAiChatOptions other = (OpenAiChatOptions)o;
        return Objects.equals(this.model, other.model) && Objects.equals(this.frequencyPenalty, other.frequencyPenalty) && Objects.equals(this.logitBias, other.logitBias) && Objects.equals(this.logprobs, other.logprobs) && Objects.equals(this.topLogprobs, other.topLogprobs) && Objects.equals(this.maxTokens, other.maxTokens) && Objects.equals(this.maxCompletionTokens, other.maxCompletionTokens) && Objects.equals(this.n, other.n) && Objects.equals(this.presencePenalty, other.presencePenalty) && Objects.equals(this.responseFormat, other.responseFormat) && Objects.equals(this.streamOptions, other.streamOptions) && Objects.equals(this.seed, other.seed) && Objects.equals(this.stop, other.stop) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.topP, other.topP) && Objects.equals(this.tools, other.tools) && Objects.equals(this.toolChoice, other.toolChoice) && Objects.equals(this.user, other.user) && Objects.equals(this.parallelToolCalls, other.parallelToolCalls) && Objects.equals(this.toolCallbacks, other.toolCallbacks) && Objects.equals(this.toolNames, other.toolNames) && Objects.equals(this.httpHeaders, other.httpHeaders) && Objects.equals(this.toolContext, other.toolContext) && Objects.equals(this.internalToolExecutionEnabled, other.internalToolExecutionEnabled) && Objects.equals(this.outputModalities, other.outputModalities) && Objects.equals(this.outputAudio, other.outputAudio) && Objects.equals(this.store, other.store) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.reasoningEffort, other.reasoningEffort) && Objects.equals(this.webSearchOptions, other.webSearchOptions) && Objects.equals(this.verbosity, other.verbosity) && Objects.equals(this.serviceTier, other.serviceTier);
    }

    public String toString() {
        return "OpenAiChatOptions: " + ModelOptionsUtils.toJsonString((Object)this);
    }

    public static final class Builder {
        protected OpenAiChatOptions options;

        public Builder() {
            this.options = new OpenAiChatOptions();
        }

        public Builder(OpenAiChatOptions options) {
            this.options = options;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder model(OpenAiApi.ChatModel openAiChatModel) {
            this.options.model = openAiChatModel.getName();
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.options.logitBias = logitBias;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.options.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.options.topLogprobs = topLogprobs;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            if (maxTokens != null && this.options.maxCompletionTokens != null) {
                logger.warn("Both maxTokens and maxCompletionTokens are set. OpenAI API does not support setting both parameters simultaneously. The previously set maxCompletionTokens ({}) will be cleared and maxTokens ({}) will be used.", (Object)this.options.maxCompletionTokens, (Object)maxTokens);
                this.options.maxCompletionTokens = null;
            }
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder maxCompletionTokens(Integer maxCompletionTokens) {
            if (maxCompletionTokens != null && this.options.maxTokens != null) {
                logger.warn("Both maxTokens and maxCompletionTokens are set. OpenAI API does not support setting both parameters simultaneously. The previously set maxTokens ({}) will be cleared and maxCompletionTokens ({}) will be used.", (Object)this.options.maxTokens, (Object)maxCompletionTokens);
                this.options.maxTokens = null;
            }
            this.options.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public Builder N(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder outputModalities(List<String> modalities) {
            this.options.outputModalities = modalities;
            return this;
        }

        public Builder outputAudio(OpenAiApi.ChatCompletionRequest.AudioParameters audio) {
            this.options.outputAudio = audio;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder streamUsage(boolean enableStreamUsage) {
            this.options.streamOptions = enableStreamUsage ? OpenAiApi.ChatCompletionRequest.StreamOptions.INCLUDE_USAGE : null;
            return this;
        }

        public Builder seed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder tools(List<OpenAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(Object toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        public Builder parallelToolCalls(Boolean parallelToolCalls) {
            this.options.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public Builder httpHeaders(Map<String, String> httpHeaders) {
            this.options.httpHeaders = httpHeaders;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public Builder store(Boolean store) {
            this.options.store = store;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.options.metadata = metadata;
            return this;
        }

        public Builder reasoningEffort(String reasoningEffort) {
            this.options.reasoningEffort = reasoningEffort;
            return this;
        }

        public Builder webSearchOptions(OpenAiApi.ChatCompletionRequest.WebSearchOptions webSearchOptions) {
            this.options.webSearchOptions = webSearchOptions;
            return this;
        }

        public Builder verbosity(String verbosity) {
            this.options.verbosity = verbosity;
            return this;
        }

        public Builder serviceTier(String serviceTier) {
            this.options.serviceTier = serviceTier;
            return this;
        }

        public Builder serviceTier(OpenAiApi.ServiceTier serviceTier) {
            this.options.serviceTier = serviceTier.getValue();
            return this;
        }

        public OpenAiChatOptions build() {
            return this.options;
        }
    }
}

