/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock.anthropic;

import java.util.List;
import org.springframework.ai.bedrock.anthropic.AnthropicChatOptions;
import org.springframework.ai.bedrock.anthropic.api.AnthropicChatBedrockApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.ai.bedrock.anthropic.chat")
public class BedrockAnthropicChatProperties {
    public static final String CONFIG_PREFIX = "spring.ai.bedrock.anthropic.chat";
    private boolean enabled = false;
    private String model = AnthropicChatBedrockApi.AnthropicChatModel.CLAUDE_V2.id();
    @NestedConfigurationProperty
    private AnthropicChatOptions options = AnthropicChatOptions.builder().withTemperature(Double.valueOf(0.7)).withMaxTokensToSample(Integer.valueOf(300)).withTopK(Integer.valueOf(10)).withStopSequences(List.of("\n\nHuman:")).build();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public AnthropicChatOptions getOptions() {
        return this.options;
    }

    public void setOptions(AnthropicChatOptions options) {
        Assert.notNull((Object)options, (String)"AnthropicChatOptions must not be null");
        Assert.notNull((Object)options.getTemperature(), (String)"AnthropicChatOptions.temperature must not be null");
        this.options = options;
    }
}

