/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock.anthropic3;

import org.springframework.ai.bedrock.anthropic3.Anthropic3ChatOptions;
import org.springframework.ai.bedrock.anthropic3.api.Anthropic3ChatBedrockApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.ai.bedrock.anthropic3.chat")
public class BedrockAnthropic3ChatProperties {
    public static final String CONFIG_PREFIX = "spring.ai.bedrock.anthropic3.chat";
    private boolean enabled = false;
    private String model = Anthropic3ChatBedrockApi.AnthropicChatModel.CLAUDE_V3_SONNET.id();
    @NestedConfigurationProperty
    private Anthropic3ChatOptions options = Anthropic3ChatOptions.builder().withTemperature(Double.valueOf(0.7)).withMaxTokens(Integer.valueOf(300)).withTopK(Integer.valueOf(10)).withAnthropicVersion("bedrock-2023-05-31").build();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Anthropic3ChatOptions getOptions() {
        return this.options;
    }

    public void setOptions(Anthropic3ChatOptions options) {
        Assert.notNull((Object)options, (String)"Anthropic3ChatOptions must not be null");
        Assert.notNull((Object)options.getTemperature(), (String)"Anthropic3ChatOptions.temperature must not be null");
        this.options = options;
    }
}

