/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.openai;

import org.springframework.ai.autoconfigure.openai.OpenAiParentProperties;
import org.springframework.ai.openai.OpenAiImageOptions;
import org.springframework.ai.openai.api.OpenAiImageApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ai.openai.image")
public class OpenAiImageProperties
extends OpenAiParentProperties {
    public static final String CONFIG_PREFIX = "spring.ai.openai.image";
    public static final String DEFAULT_IMAGE_MODEL = OpenAiImageApi.ImageModel.DALL_E_3.getValue();
    private boolean enabled = true;
    @NestedConfigurationProperty
    private OpenAiImageOptions options = OpenAiImageOptions.builder().withModel(DEFAULT_IMAGE_MODEL).build();

    public OpenAiImageOptions getOptions() {
        return this.options;
    }

    public void setOptions(OpenAiImageOptions options) {
        this.options = options;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

