/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.mongo;

import io.micrometer.observation.ObservationRegistry;
import java.util.Arrays;
import org.springframework.ai.autoconfigure.vectorstore.mongo.MongoDBAtlasVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.MongoDBAtlasVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={MongoDBAtlasVectorStore.class, EmbeddingModel.class, MongoTemplate.class})
@EnableConfigurationProperties(value={MongoDBAtlasVectorStoreProperties.class})
public class MongoDBAtlasVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy batchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    MongoDBAtlasVectorStore vectorStore(MongoTemplate mongoTemplate, EmbeddingModel embeddingModel, MongoDBAtlasVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        MongoDBAtlasVectorStore.MongoDBVectorStoreConfig.Builder builder = MongoDBAtlasVectorStore.MongoDBVectorStoreConfig.builder();
        if (StringUtils.hasText((String)properties.getCollectionName())) {
            builder.withCollectionName(properties.getCollectionName());
        }
        if (StringUtils.hasText((String)properties.getPathName())) {
            builder.withPathName(properties.getPathName());
        }
        if (StringUtils.hasText((String)properties.getIndexName())) {
            builder.withVectorIndexName(properties.getIndexName());
        }
        if (!properties.getMetadataFieldsToFilter().isEmpty()) {
            builder.withMetadataFieldsToFilter(properties.getMetadataFieldsToFilter());
        }
        MongoDBAtlasVectorStore.MongoDBVectorStoreConfig config = builder.build();
        return new MongoDBAtlasVectorStore(mongoTemplate, embeddingModel, config, properties.isInitializeSchema(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP), (VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null), batchingStrategy);
    }

    @Bean
    public Converter<MimeType, String> mimeTypeToStringConverter() {
        return new Converter<MimeType, String>(){

            public String convert(MimeType source) {
                return source.toString();
            }
        };
    }

    @Bean
    public Converter<String, MimeType> stringToMimeTypeConverter() {
        return new Converter<String, MimeType>(){

            public MimeType convert(String source) {
                return MimeType.valueOf((String)source);
            }
        };
    }

    @Bean
    public MongoCustomConversions mongoCustomConversions() {
        return new MongoCustomConversions(Arrays.asList(this.mimeTypeToStringConverter(), this.stringToMimeTypeConverter()));
    }
}

