/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.testcontainers.service.connection.qdrant;

import org.springframework.ai.autoconfigure.vectorstore.qdrant.QdrantConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.qdrant.QdrantContainer;

class QdrantContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<QdrantContainer, QdrantConnectionDetails> {
    QdrantContainerConnectionDetailsFactory() {
    }

    public QdrantConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<QdrantContainer> source) {
        return new QdrantContainerConnectionDetails(source);
    }

    private static final class QdrantContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<QdrantContainer>
    implements QdrantConnectionDetails {
        private QdrantContainerConnectionDetails(ContainerConnectionSource<QdrantContainer> source) {
            super(source);
        }

        public String getHost() {
            return ((QdrantContainer)this.getContainer()).getHost();
        }

        public int getPort() {
            return ((QdrantContainer)this.getContainer()).getMappedPort(6334);
        }

        public String getApiKey() {
            return (String)((QdrantContainer)this.getContainer()).getEnvMap().get("QDRANT__SERVICE__API_KEY");
        }
    }
}

